package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.{WrapperBoolean, NonEmptyString}
import scala.jdk.CollectionConverters.*
final case class S3ReportExportConfig(
    bucket: Option[NonEmptyString] = None,
    bucketOwner: Option[String] = None,
    path: Option[String] = None,
    packaging: Option[zio.aws.codebuild.model.ReportPackagingType] = None,
    encryptionKey: Option[NonEmptyString] = None,
    encryptionDisabled: Option[WrapperBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.S3ReportExportConfig = {
    import S3ReportExportConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.S3ReportExportConfig
      .builder()
      .optionallyWith(
        bucket.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(bucketOwner.map(value => value: java.lang.String))(
        _.bucketOwner
      )
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(packaging.map(value => value.unwrap))(_.packaging)
      .optionallyWith(
        encryptionKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKey)
      .optionallyWith(
        encryptionDisabled.map(value =>
          WrapperBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.encryptionDisabled)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.S3ReportExportConfig.ReadOnly =
    zio.aws.codebuild.model.S3ReportExportConfig.wrap(buildAwsValue())
}
object S3ReportExportConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.S3ReportExportConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.S3ReportExportConfig =
      zio.aws.codebuild.model.S3ReportExportConfig(
        bucket.map(value => value),
        bucketOwner.map(value => value),
        path.map(value => value),
        packaging.map(value => value),
        encryptionKey.map(value => value),
        encryptionDisabled.map(value => value)
      )
    def bucket: Option[NonEmptyString]
    def bucketOwner: Option[String]
    def path: Option[String]
    def packaging: Option[zio.aws.codebuild.model.ReportPackagingType]
    def encryptionKey: Option[NonEmptyString]
    def encryptionDisabled: Option[WrapperBoolean]
    def getBucket: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getBucketOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketOwner", bucketOwner)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getPackaging
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ReportPackagingType] =
      AwsError.unwrapOptionField("packaging", packaging)
    def getEncryptionKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getEncryptionDisabled: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("encryptionDisabled", encryptionDisabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.S3ReportExportConfig
  ) extends zio.aws.codebuild.model.S3ReportExportConfig.ReadOnly {
    override val bucket: Option[NonEmptyString] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val bucketOwner: Option[String] =
      scala.Option(impl.bucketOwner()).map(value => value: String)
    override val path: Option[String] =
      scala.Option(impl.path()).map(value => value: String)
    override val packaging
        : Option[zio.aws.codebuild.model.ReportPackagingType] = scala
      .Option(impl.packaging())
      .map(value => zio.aws.codebuild.model.ReportPackagingType.wrap(value))
    override val encryptionKey: Option[NonEmptyString] = scala
      .Option(impl.encryptionKey())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val encryptionDisabled: Option[WrapperBoolean] = scala
      .Option(impl.encryptionDisabled())
      .map(value => zio.aws.codebuild.model.primitives.WrapperBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.S3ReportExportConfig
  ): zio.aws.codebuild.model.S3ReportExportConfig.ReadOnly = new Wrapper(impl)
}
