package zio.aws.codebuild.model
import scala.jdk.CollectionConverters.*
sealed trait ReportType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.ReportType
}
object ReportType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.ReportType
  ): zio.aws.codebuild.model.ReportType = value match {
    case software.amazon.awssdk.services.codebuild.model.ReportType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.ReportType.TEST =>
      val r = TEST
      r
    case software.amazon.awssdk.services.codebuild.model.ReportType.CODE_COVERAGE =>
      val r = CODE_COVERAGE
      r
  }
  case object unknownToSdkVersion extends zio.aws.codebuild.model.ReportType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportType =
      software.amazon.awssdk.services.codebuild.model.ReportType.UNKNOWN_TO_SDK_VERSION
  }
  case object TEST extends zio.aws.codebuild.model.ReportType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportType =
      software.amazon.awssdk.services.codebuild.model.ReportType.TEST
  }
  case object CODE_COVERAGE extends zio.aws.codebuild.model.ReportType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportType =
      software.amazon.awssdk.services.codebuild.model.ReportType.CODE_COVERAGE
  }
}
