package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateReportGroupResponse(
    reportGroup: Option[zio.aws.codebuild.model.ReportGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.UpdateReportGroupResponse = {
    import UpdateReportGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.UpdateReportGroupResponse
      .builder()
      .optionallyWith(reportGroup.map(value => value.buildAwsValue()))(
        _.reportGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.UpdateReportGroupResponse.ReadOnly =
    zio.aws.codebuild.model.UpdateReportGroupResponse.wrap(buildAwsValue())
}
object UpdateReportGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.UpdateReportGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.UpdateReportGroupResponse =
      zio.aws.codebuild.model
        .UpdateReportGroupResponse(reportGroup.map(value => value.asEditable))
    def reportGroup: Option[zio.aws.codebuild.model.ReportGroup.ReadOnly]
    def getReportGroup
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ReportGroup.ReadOnly] =
      AwsError.unwrapOptionField("reportGroup", reportGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateReportGroupResponse
  ) extends zio.aws.codebuild.model.UpdateReportGroupResponse.ReadOnly {
    override val reportGroup
        : Option[zio.aws.codebuild.model.ReportGroup.ReadOnly] = scala
      .Option(impl.reportGroup())
      .map(value => zio.aws.codebuild.model.ReportGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateReportGroupResponse
  ): zio.aws.codebuild.model.UpdateReportGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
