package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateWebhookResponse(
    webhook: Option[zio.aws.codebuild.model.Webhook] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.CreateWebhookResponse = {
    import CreateWebhookResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.CreateWebhookResponse
      .builder()
      .optionallyWith(webhook.map(value => value.buildAwsValue()))(_.webhook)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.CreateWebhookResponse.ReadOnly =
    zio.aws.codebuild.model.CreateWebhookResponse.wrap(buildAwsValue())
}
object CreateWebhookResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.CreateWebhookResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.CreateWebhookResponse =
      zio.aws.codebuild.model
        .CreateWebhookResponse(webhook.map(value => value.asEditable))
    def webhook: Option[zio.aws.codebuild.model.Webhook.ReadOnly]
    def getWebhook
        : ZIO[Any, AwsError, zio.aws.codebuild.model.Webhook.ReadOnly] =
      AwsError.unwrapOptionField("webhook", webhook)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.CreateWebhookResponse
  ) extends zio.aws.codebuild.model.CreateWebhookResponse.ReadOnly {
    override val webhook: Option[zio.aws.codebuild.model.Webhook.ReadOnly] =
      scala
        .Option(impl.webhook())
        .map(value => zio.aws.codebuild.model.Webhook.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.CreateWebhookResponse
  ): zio.aws.codebuild.model.CreateWebhookResponse.ReadOnly = new Wrapper(impl)
}
