package zio.aws.codebuild.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.{
  TimeOut,
  WrapperBoolean,
  GitCloneDepth,
  NonEmptyString
}
import scala.jdk.CollectionConverters.*
final case class StartBuildBatchRequest(
    projectName: NonEmptyString,
    secondarySourcesOverride: Option[
      Iterable[zio.aws.codebuild.model.ProjectSource]
    ] = None,
    secondarySourcesVersionOverride: Option[
      Iterable[zio.aws.codebuild.model.ProjectSourceVersion]
    ] = None,
    sourceVersion: Option[String] = None,
    artifactsOverride: Option[zio.aws.codebuild.model.ProjectArtifacts] = None,
    secondaryArtifactsOverride: Option[
      Iterable[zio.aws.codebuild.model.ProjectArtifacts]
    ] = None,
    environmentVariablesOverride: Option[
      Iterable[zio.aws.codebuild.model.EnvironmentVariable]
    ] = None,
    sourceTypeOverride: Option[zio.aws.codebuild.model.SourceType] = None,
    sourceLocationOverride: Option[String] = None,
    sourceAuthOverride: Option[zio.aws.codebuild.model.SourceAuth] = None,
    gitCloneDepthOverride: Option[GitCloneDepth] = None,
    gitSubmodulesConfigOverride: Option[
      zio.aws.codebuild.model.GitSubmodulesConfig
    ] = None,
    buildspecOverride: Option[String] = None,
    insecureSslOverride: Option[WrapperBoolean] = None,
    reportBuildBatchStatusOverride: Option[WrapperBoolean] = None,
    environmentTypeOverride: Option[zio.aws.codebuild.model.EnvironmentType] =
      None,
    imageOverride: Option[NonEmptyString] = None,
    computeTypeOverride: Option[zio.aws.codebuild.model.ComputeType] = None,
    certificateOverride: Option[String] = None,
    cacheOverride: Option[zio.aws.codebuild.model.ProjectCache] = None,
    serviceRoleOverride: Option[NonEmptyString] = None,
    privilegedModeOverride: Option[WrapperBoolean] = None,
    buildTimeoutInMinutesOverride: Option[TimeOut] = None,
    queuedTimeoutInMinutesOverride: Option[TimeOut] = None,
    encryptionKeyOverride: Option[NonEmptyString] = None,
    idempotencyToken: Option[String] = None,
    logsConfigOverride: Option[zio.aws.codebuild.model.LogsConfig] = None,
    registryCredentialOverride: Option[
      zio.aws.codebuild.model.RegistryCredential
    ] = None,
    imagePullCredentialsTypeOverride: Option[
      zio.aws.codebuild.model.ImagePullCredentialsType
    ] = None,
    buildBatchConfigOverride: Option[
      zio.aws.codebuild.model.ProjectBuildBatchConfig
    ] = None,
    debugSessionEnabled: Option[WrapperBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.StartBuildBatchRequest = {
    import StartBuildBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.StartBuildBatchRequest
      .builder()
      .projectName(NonEmptyString.unwrap(projectName): java.lang.String)
      .optionallyWith(
        secondarySourcesOverride.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySourcesOverride)
      .optionallyWith(
        secondarySourcesVersionOverride.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySourcesVersionOverride)
      .optionallyWith(sourceVersion.map(value => value: java.lang.String))(
        _.sourceVersion
      )
      .optionallyWith(artifactsOverride.map(value => value.buildAwsValue()))(
        _.artifactsOverride
      )
      .optionallyWith(
        secondaryArtifactsOverride.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondaryArtifactsOverride)
      .optionallyWith(
        environmentVariablesOverride.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentVariablesOverride)
      .optionallyWith(sourceTypeOverride.map(value => value.unwrap))(
        _.sourceTypeOverride
      )
      .optionallyWith(
        sourceLocationOverride.map(value => value: java.lang.String)
      )(_.sourceLocationOverride)
      .optionallyWith(sourceAuthOverride.map(value => value.buildAwsValue()))(
        _.sourceAuthOverride
      )
      .optionallyWith(
        gitCloneDepthOverride.map(value => GitCloneDepth.unwrap(value): Integer)
      )(_.gitCloneDepthOverride)
      .optionallyWith(
        gitSubmodulesConfigOverride.map(value => value.buildAwsValue())
      )(_.gitSubmodulesConfigOverride)
      .optionallyWith(buildspecOverride.map(value => value: java.lang.String))(
        _.buildspecOverride
      )
      .optionallyWith(
        insecureSslOverride.map(value =>
          WrapperBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.insecureSslOverride)
      .optionallyWith(
        reportBuildBatchStatusOverride.map(value =>
          WrapperBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.reportBuildBatchStatusOverride)
      .optionallyWith(environmentTypeOverride.map(value => value.unwrap))(
        _.environmentTypeOverride
      )
      .optionallyWith(
        imageOverride.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.imageOverride)
      .optionallyWith(computeTypeOverride.map(value => value.unwrap))(
        _.computeTypeOverride
      )
      .optionallyWith(
        certificateOverride.map(value => value: java.lang.String)
      )(_.certificateOverride)
      .optionallyWith(cacheOverride.map(value => value.buildAwsValue()))(
        _.cacheOverride
      )
      .optionallyWith(
        serviceRoleOverride.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.serviceRoleOverride)
      .optionallyWith(
        privilegedModeOverride.map(value =>
          WrapperBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.privilegedModeOverride)
      .optionallyWith(
        buildTimeoutInMinutesOverride.map(value =>
          TimeOut.unwrap(value): Integer
        )
      )(_.buildTimeoutInMinutesOverride)
      .optionallyWith(
        queuedTimeoutInMinutesOverride.map(value =>
          TimeOut.unwrap(value): Integer
        )
      )(_.queuedTimeoutInMinutesOverride)
      .optionallyWith(
        encryptionKeyOverride.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKeyOverride)
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .optionallyWith(logsConfigOverride.map(value => value.buildAwsValue()))(
        _.logsConfigOverride
      )
      .optionallyWith(
        registryCredentialOverride.map(value => value.buildAwsValue())
      )(_.registryCredentialOverride)
      .optionallyWith(
        imagePullCredentialsTypeOverride.map(value => value.unwrap)
      )(_.imagePullCredentialsTypeOverride)
      .optionallyWith(
        buildBatchConfigOverride.map(value => value.buildAwsValue())
      )(_.buildBatchConfigOverride)
      .optionallyWith(
        debugSessionEnabled.map(value =>
          WrapperBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.debugSessionEnabled)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.StartBuildBatchRequest.ReadOnly =
    zio.aws.codebuild.model.StartBuildBatchRequest.wrap(buildAwsValue())
}
object StartBuildBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.StartBuildBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.StartBuildBatchRequest =
      zio.aws.codebuild.model.StartBuildBatchRequest(
        projectName,
        secondarySourcesOverride.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secondarySourcesVersionOverride.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceVersion.map(value => value),
        artifactsOverride.map(value => value.asEditable),
        secondaryArtifactsOverride.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environmentVariablesOverride.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceTypeOverride.map(value => value),
        sourceLocationOverride.map(value => value),
        sourceAuthOverride.map(value => value.asEditable),
        gitCloneDepthOverride.map(value => value),
        gitSubmodulesConfigOverride.map(value => value.asEditable),
        buildspecOverride.map(value => value),
        insecureSslOverride.map(value => value),
        reportBuildBatchStatusOverride.map(value => value),
        environmentTypeOverride.map(value => value),
        imageOverride.map(value => value),
        computeTypeOverride.map(value => value),
        certificateOverride.map(value => value),
        cacheOverride.map(value => value.asEditable),
        serviceRoleOverride.map(value => value),
        privilegedModeOverride.map(value => value),
        buildTimeoutInMinutesOverride.map(value => value),
        queuedTimeoutInMinutesOverride.map(value => value),
        encryptionKeyOverride.map(value => value),
        idempotencyToken.map(value => value),
        logsConfigOverride.map(value => value.asEditable),
        registryCredentialOverride.map(value => value.asEditable),
        imagePullCredentialsTypeOverride.map(value => value),
        buildBatchConfigOverride.map(value => value.asEditable),
        debugSessionEnabled.map(value => value)
      )
    def projectName: NonEmptyString
    def secondarySourcesOverride
        : Option[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]]
    def secondarySourcesVersionOverride
        : Option[List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]]
    def sourceVersion: Option[String]
    def artifactsOverride
        : Option[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly]
    def secondaryArtifactsOverride
        : Option[List[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly]]
    def environmentVariablesOverride
        : Option[List[zio.aws.codebuild.model.EnvironmentVariable.ReadOnly]]
    def sourceTypeOverride: Option[zio.aws.codebuild.model.SourceType]
    def sourceLocationOverride: Option[String]
    def sourceAuthOverride: Option[zio.aws.codebuild.model.SourceAuth.ReadOnly]
    def gitCloneDepthOverride: Option[GitCloneDepth]
    def gitSubmodulesConfigOverride
        : Option[zio.aws.codebuild.model.GitSubmodulesConfig.ReadOnly]
    def buildspecOverride: Option[String]
    def insecureSslOverride: Option[WrapperBoolean]
    def reportBuildBatchStatusOverride: Option[WrapperBoolean]
    def environmentTypeOverride: Option[zio.aws.codebuild.model.EnvironmentType]
    def imageOverride: Option[NonEmptyString]
    def computeTypeOverride: Option[zio.aws.codebuild.model.ComputeType]
    def certificateOverride: Option[String]
    def cacheOverride: Option[zio.aws.codebuild.model.ProjectCache.ReadOnly]
    def serviceRoleOverride: Option[NonEmptyString]
    def privilegedModeOverride: Option[WrapperBoolean]
    def buildTimeoutInMinutesOverride: Option[TimeOut]
    def queuedTimeoutInMinutesOverride: Option[TimeOut]
    def encryptionKeyOverride: Option[NonEmptyString]
    def idempotencyToken: Option[String]
    def logsConfigOverride: Option[zio.aws.codebuild.model.LogsConfig.ReadOnly]
    def registryCredentialOverride
        : Option[zio.aws.codebuild.model.RegistryCredential.ReadOnly]
    def imagePullCredentialsTypeOverride
        : Option[zio.aws.codebuild.model.ImagePullCredentialsType]
    def buildBatchConfigOverride
        : Option[zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly]
    def debugSessionEnabled: Option[WrapperBoolean]
    def getProjectName: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(projectName)
    def getSecondarySourcesOverride: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSource.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondarySourcesOverride",
      secondarySourcesOverride
    )
    def getSecondarySourcesVersionOverride: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondarySourcesVersionOverride",
      secondarySourcesVersionOverride
    )
    def getSourceVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getArtifactsOverride: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectArtifacts.ReadOnly
    ] = AwsError.unwrapOptionField("artifactsOverride", artifactsOverride)
    def getSecondaryArtifactsOverride: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectArtifacts.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondaryArtifactsOverride",
      secondaryArtifactsOverride
    )
    def getEnvironmentVariablesOverride: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.EnvironmentVariable.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "environmentVariablesOverride",
      environmentVariablesOverride
    )
    def getSourceTypeOverride
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SourceType] =
      AwsError.unwrapOptionField("sourceTypeOverride", sourceTypeOverride)
    def getSourceLocationOverride: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("sourceLocationOverride", sourceLocationOverride)
    def getSourceAuthOverride
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SourceAuth.ReadOnly] =
      AwsError.unwrapOptionField("sourceAuthOverride", sourceAuthOverride)
    def getGitCloneDepthOverride: ZIO[Any, AwsError, GitCloneDepth] =
      AwsError.unwrapOptionField("gitCloneDepthOverride", gitCloneDepthOverride)
    def getGitSubmodulesConfigOverride: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.GitSubmodulesConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "gitSubmodulesConfigOverride",
      gitSubmodulesConfigOverride
    )
    def getBuildspecOverride: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("buildspecOverride", buildspecOverride)
    def getInsecureSslOverride: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("insecureSslOverride", insecureSslOverride)
    def getReportBuildBatchStatusOverride: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField(
        "reportBuildBatchStatusOverride",
        reportBuildBatchStatusOverride
      )
    def getEnvironmentTypeOverride
        : ZIO[Any, AwsError, zio.aws.codebuild.model.EnvironmentType] = AwsError
      .unwrapOptionField("environmentTypeOverride", environmentTypeOverride)
    def getImageOverride: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imageOverride", imageOverride)
    def getComputeTypeOverride
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ComputeType] =
      AwsError.unwrapOptionField("computeTypeOverride", computeTypeOverride)
    def getCertificateOverride: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateOverride", certificateOverride)
    def getCacheOverride
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      AwsError.unwrapOptionField("cacheOverride", cacheOverride)
    def getServiceRoleOverride: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceRoleOverride", serviceRoleOverride)
    def getPrivilegedModeOverride: ZIO[Any, AwsError, WrapperBoolean] = AwsError
      .unwrapOptionField("privilegedModeOverride", privilegedModeOverride)
    def getBuildTimeoutInMinutesOverride: ZIO[Any, AwsError, TimeOut] =
      AwsError.unwrapOptionField(
        "buildTimeoutInMinutesOverride",
        buildTimeoutInMinutesOverride
      )
    def getQueuedTimeoutInMinutesOverride: ZIO[Any, AwsError, TimeOut] =
      AwsError.unwrapOptionField(
        "queuedTimeoutInMinutesOverride",
        queuedTimeoutInMinutesOverride
      )
    def getEncryptionKeyOverride: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKeyOverride", encryptionKeyOverride)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getLogsConfigOverride
        : ZIO[Any, AwsError, zio.aws.codebuild.model.LogsConfig.ReadOnly] =
      AwsError.unwrapOptionField("logsConfigOverride", logsConfigOverride)
    def getRegistryCredentialOverride: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.RegistryCredential.ReadOnly
    ] = AwsError.unwrapOptionField(
      "registryCredentialOverride",
      registryCredentialOverride
    )
    def getImagePullCredentialsTypeOverride
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ImagePullCredentialsType] =
      AwsError.unwrapOptionField(
        "imagePullCredentialsTypeOverride",
        imagePullCredentialsTypeOverride
      )
    def getBuildBatchConfigOverride: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "buildBatchConfigOverride",
      buildBatchConfigOverride
    )
    def getDebugSessionEnabled: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("debugSessionEnabled", debugSessionEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.StartBuildBatchRequest
  ) extends zio.aws.codebuild.model.StartBuildBatchRequest.ReadOnly {
    override val projectName: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.projectName())
    override val secondarySourcesOverride
        : Option[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]] = scala
      .Option(impl.secondarySourcesOverride())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectSource.wrap(item)
        }.toList
      )
    override val secondarySourcesVersionOverride
        : Option[List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]] =
      scala
        .Option(impl.secondarySourcesVersionOverride())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ProjectSourceVersion.wrap(item)
          }.toList
        )
    override val sourceVersion: Option[String] =
      scala.Option(impl.sourceVersion()).map(value => value: String)
    override val artifactsOverride
        : Option[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly] = scala
      .Option(impl.artifactsOverride())
      .map(value => zio.aws.codebuild.model.ProjectArtifacts.wrap(value))
    override val secondaryArtifactsOverride
        : Option[List[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly]] =
      scala
        .Option(impl.secondaryArtifactsOverride())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ProjectArtifacts.wrap(item)
          }.toList
        )
    override val environmentVariablesOverride
        : Option[List[zio.aws.codebuild.model.EnvironmentVariable.ReadOnly]] =
      scala
        .Option(impl.environmentVariablesOverride())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.EnvironmentVariable.wrap(item)
          }.toList
        )
    override val sourceTypeOverride
        : Option[zio.aws.codebuild.model.SourceType] = scala
      .Option(impl.sourceTypeOverride())
      .map(value => zio.aws.codebuild.model.SourceType.wrap(value))
    override val sourceLocationOverride: Option[String] =
      scala.Option(impl.sourceLocationOverride()).map(value => value: String)
    override val sourceAuthOverride
        : Option[zio.aws.codebuild.model.SourceAuth.ReadOnly] = scala
      .Option(impl.sourceAuthOverride())
      .map(value => zio.aws.codebuild.model.SourceAuth.wrap(value))
    override val gitCloneDepthOverride: Option[GitCloneDepth] = scala
      .Option(impl.gitCloneDepthOverride())
      .map(value => zio.aws.codebuild.model.primitives.GitCloneDepth(value))
    override val gitSubmodulesConfigOverride
        : Option[zio.aws.codebuild.model.GitSubmodulesConfig.ReadOnly] = scala
      .Option(impl.gitSubmodulesConfigOverride())
      .map(value => zio.aws.codebuild.model.GitSubmodulesConfig.wrap(value))
    override val buildspecOverride: Option[String] =
      scala.Option(impl.buildspecOverride()).map(value => value: String)
    override val insecureSslOverride: Option[WrapperBoolean] = scala
      .Option(impl.insecureSslOverride())
      .map(value => zio.aws.codebuild.model.primitives.WrapperBoolean(value))
    override val reportBuildBatchStatusOverride: Option[WrapperBoolean] = scala
      .Option(impl.reportBuildBatchStatusOverride())
      .map(value => zio.aws.codebuild.model.primitives.WrapperBoolean(value))
    override val environmentTypeOverride
        : Option[zio.aws.codebuild.model.EnvironmentType] = scala
      .Option(impl.environmentTypeOverride())
      .map(value => zio.aws.codebuild.model.EnvironmentType.wrap(value))
    override val imageOverride: Option[NonEmptyString] = scala
      .Option(impl.imageOverride())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val computeTypeOverride
        : Option[zio.aws.codebuild.model.ComputeType] = scala
      .Option(impl.computeTypeOverride())
      .map(value => zio.aws.codebuild.model.ComputeType.wrap(value))
    override val certificateOverride: Option[String] =
      scala.Option(impl.certificateOverride()).map(value => value: String)
    override val cacheOverride
        : Option[zio.aws.codebuild.model.ProjectCache.ReadOnly] = scala
      .Option(impl.cacheOverride())
      .map(value => zio.aws.codebuild.model.ProjectCache.wrap(value))
    override val serviceRoleOverride: Option[NonEmptyString] = scala
      .Option(impl.serviceRoleOverride())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val privilegedModeOverride: Option[WrapperBoolean] = scala
      .Option(impl.privilegedModeOverride())
      .map(value => zio.aws.codebuild.model.primitives.WrapperBoolean(value))
    override val buildTimeoutInMinutesOverride: Option[TimeOut] = scala
      .Option(impl.buildTimeoutInMinutesOverride())
      .map(value => zio.aws.codebuild.model.primitives.TimeOut(value))
    override val queuedTimeoutInMinutesOverride: Option[TimeOut] = scala
      .Option(impl.queuedTimeoutInMinutesOverride())
      .map(value => zio.aws.codebuild.model.primitives.TimeOut(value))
    override val encryptionKeyOverride: Option[NonEmptyString] = scala
      .Option(impl.encryptionKeyOverride())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val idempotencyToken: Option[String] =
      scala.Option(impl.idempotencyToken()).map(value => value: String)
    override val logsConfigOverride
        : Option[zio.aws.codebuild.model.LogsConfig.ReadOnly] = scala
      .Option(impl.logsConfigOverride())
      .map(value => zio.aws.codebuild.model.LogsConfig.wrap(value))
    override val registryCredentialOverride
        : Option[zio.aws.codebuild.model.RegistryCredential.ReadOnly] = scala
      .Option(impl.registryCredentialOverride())
      .map(value => zio.aws.codebuild.model.RegistryCredential.wrap(value))
    override val imagePullCredentialsTypeOverride
        : Option[zio.aws.codebuild.model.ImagePullCredentialsType] = scala
      .Option(impl.imagePullCredentialsTypeOverride())
      .map(value =>
        zio.aws.codebuild.model.ImagePullCredentialsType.wrap(value)
      )
    override val buildBatchConfigOverride
        : Option[zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly] =
      scala
        .Option(impl.buildBatchConfigOverride())
        .map(value =>
          zio.aws.codebuild.model.ProjectBuildBatchConfig.wrap(value)
        )
    override val debugSessionEnabled: Option[WrapperBoolean] = scala
      .Option(impl.debugSessionEnabled())
      .map(value => zio.aws.codebuild.model.primitives.WrapperBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.StartBuildBatchRequest
  ): zio.aws.codebuild.model.StartBuildBatchRequest.ReadOnly = new Wrapper(impl)
}
