package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.{WrapperBoolean, NonEmptyString}
import scala.jdk.CollectionConverters.*
final case class ProjectEnvironment(
    `type`: zio.aws.codebuild.model.EnvironmentType,
    image: NonEmptyString,
    computeType: zio.aws.codebuild.model.ComputeType,
    environmentVariables: Option[
      Iterable[zio.aws.codebuild.model.EnvironmentVariable]
    ] = None,
    privilegedMode: Option[WrapperBoolean] = None,
    certificate: Option[String] = None,
    registryCredential: Option[zio.aws.codebuild.model.RegistryCredential] =
      None,
    imagePullCredentialsType: Option[
      zio.aws.codebuild.model.ImagePullCredentialsType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ProjectEnvironment = {
    import ProjectEnvironment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ProjectEnvironment
      .builder()
      .`type`(`type`.unwrap)
      .image(NonEmptyString.unwrap(image): java.lang.String)
      .computeType(computeType.unwrap)
      .optionallyWith(
        environmentVariables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentVariables)
      .optionallyWith(
        privilegedMode.map(value =>
          WrapperBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.privilegedMode)
      .optionallyWith(certificate.map(value => value: java.lang.String))(
        _.certificate
      )
      .optionallyWith(registryCredential.map(value => value.buildAwsValue()))(
        _.registryCredential
      )
      .optionallyWith(imagePullCredentialsType.map(value => value.unwrap))(
        _.imagePullCredentialsType
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ProjectEnvironment.ReadOnly =
    zio.aws.codebuild.model.ProjectEnvironment.wrap(buildAwsValue())
}
object ProjectEnvironment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ProjectEnvironment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ProjectEnvironment =
      zio.aws.codebuild.model.ProjectEnvironment(
        `type`,
        image,
        computeType,
        environmentVariables.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privilegedMode.map(value => value),
        certificate.map(value => value),
        registryCredential.map(value => value.asEditable),
        imagePullCredentialsType.map(value => value)
      )
    def `type`: zio.aws.codebuild.model.EnvironmentType
    def image: NonEmptyString
    def computeType: zio.aws.codebuild.model.ComputeType
    def environmentVariables
        : Option[List[zio.aws.codebuild.model.EnvironmentVariable.ReadOnly]]
    def privilegedMode: Option[WrapperBoolean]
    def certificate: Option[String]
    def registryCredential
        : Option[zio.aws.codebuild.model.RegistryCredential.ReadOnly]
    def imagePullCredentialsType
        : Option[zio.aws.codebuild.model.ImagePullCredentialsType]
    def getType: ZIO[Any, Nothing, zio.aws.codebuild.model.EnvironmentType] =
      ZIO.succeed(`type`)
    def getImage: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(image)
    def getComputeType: ZIO[Any, Nothing, zio.aws.codebuild.model.ComputeType] =
      ZIO.succeed(computeType)
    def getEnvironmentVariables: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.EnvironmentVariable.ReadOnly
    ]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
    def getPrivilegedMode: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("privilegedMode", privilegedMode)
    def getCertificate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getRegistryCredential: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.RegistryCredential.ReadOnly
    ] = AwsError.unwrapOptionField("registryCredential", registryCredential)
    def getImagePullCredentialsType
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ImagePullCredentialsType] =
      AwsError.unwrapOptionField(
        "imagePullCredentialsType",
        imagePullCredentialsType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectEnvironment
  ) extends zio.aws.codebuild.model.ProjectEnvironment.ReadOnly {
    override val `type`: zio.aws.codebuild.model.EnvironmentType =
      zio.aws.codebuild.model.EnvironmentType.wrap(impl.`type`())
    override val image: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.image())
    override val computeType: zio.aws.codebuild.model.ComputeType =
      zio.aws.codebuild.model.ComputeType.wrap(impl.computeType())
    override val environmentVariables
        : Option[List[zio.aws.codebuild.model.EnvironmentVariable.ReadOnly]] =
      scala
        .Option(impl.environmentVariables())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.EnvironmentVariable.wrap(item)
          }.toList
        )
    override val privilegedMode: Option[WrapperBoolean] = scala
      .Option(impl.privilegedMode())
      .map(value => zio.aws.codebuild.model.primitives.WrapperBoolean(value))
    override val certificate: Option[String] =
      scala.Option(impl.certificate()).map(value => value: String)
    override val registryCredential
        : Option[zio.aws.codebuild.model.RegistryCredential.ReadOnly] = scala
      .Option(impl.registryCredential())
      .map(value => zio.aws.codebuild.model.RegistryCredential.wrap(value))
    override val imagePullCredentialsType
        : Option[zio.aws.codebuild.model.ImagePullCredentialsType] = scala
      .Option(impl.imagePullCredentialsType())
      .map(value =>
        zio.aws.codebuild.model.ImagePullCredentialsType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectEnvironment
  ): zio.aws.codebuild.model.ProjectEnvironment.ReadOnly = new Wrapper(impl)
}
