package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class ListBuildsForProjectRequest(
    projectName: NonEmptyString,
    sortOrder: Option[zio.aws.codebuild.model.SortOrderType] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest = {
    import ListBuildsForProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest
      .builder()
      .projectName(NonEmptyString.unwrap(projectName): java.lang.String)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ListBuildsForProjectRequest.ReadOnly =
    zio.aws.codebuild.model.ListBuildsForProjectRequest.wrap(buildAwsValue())
}
object ListBuildsForProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListBuildsForProjectRequest =
      zio.aws.codebuild.model.ListBuildsForProjectRequest(
        projectName,
        sortOrder.map(value => value),
        nextToken.map(value => value)
      )
    def projectName: NonEmptyString
    def sortOrder: Option[zio.aws.codebuild.model.SortOrderType]
    def nextToken: Option[String]
    def getProjectName: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(projectName)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest
  ) extends zio.aws.codebuild.model.ListBuildsForProjectRequest.ReadOnly {
    override val projectName: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.projectName())
    override val sortOrder: Option[zio.aws.codebuild.model.SortOrderType] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.codebuild.model.SortOrderType.wrap(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest
  ): zio.aws.codebuild.model.ListBuildsForProjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
