package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.WrapperBoolean
import scala.jdk.CollectionConverters.*
final case class ProjectArtifacts(
    `type`: zio.aws.codebuild.model.ArtifactsType,
    location: Option[String] = None,
    path: Option[String] = None,
    namespaceType: Option[zio.aws.codebuild.model.ArtifactNamespace] = None,
    name: Option[String] = None,
    packaging: Option[zio.aws.codebuild.model.ArtifactPackaging] = None,
    overrideArtifactName: Option[WrapperBoolean] = None,
    encryptionDisabled: Option[WrapperBoolean] = None,
    artifactIdentifier: Option[String] = None,
    bucketOwnerAccess: Option[zio.aws.codebuild.model.BucketOwnerAccess] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ProjectArtifacts = {
    import ProjectArtifacts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ProjectArtifacts
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(namespaceType.map(value => value.unwrap))(_.namespaceType)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(packaging.map(value => value.unwrap))(_.packaging)
      .optionallyWith(
        overrideArtifactName.map(value =>
          WrapperBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.overrideArtifactName)
      .optionallyWith(
        encryptionDisabled.map(value =>
          WrapperBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.encryptionDisabled)
      .optionallyWith(artifactIdentifier.map(value => value: java.lang.String))(
        _.artifactIdentifier
      )
      .optionallyWith(bucketOwnerAccess.map(value => value.unwrap))(
        _.bucketOwnerAccess
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ProjectArtifacts.ReadOnly =
    zio.aws.codebuild.model.ProjectArtifacts.wrap(buildAwsValue())
}
object ProjectArtifacts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ProjectArtifacts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ProjectArtifacts =
      zio.aws.codebuild.model.ProjectArtifacts(
        `type`,
        location.map(value => value),
        path.map(value => value),
        namespaceType.map(value => value),
        name.map(value => value),
        packaging.map(value => value),
        overrideArtifactName.map(value => value),
        encryptionDisabled.map(value => value),
        artifactIdentifier.map(value => value),
        bucketOwnerAccess.map(value => value)
      )
    def `type`: zio.aws.codebuild.model.ArtifactsType
    def location: Option[String]
    def path: Option[String]
    def namespaceType: Option[zio.aws.codebuild.model.ArtifactNamespace]
    def name: Option[String]
    def packaging: Option[zio.aws.codebuild.model.ArtifactPackaging]
    def overrideArtifactName: Option[WrapperBoolean]
    def encryptionDisabled: Option[WrapperBoolean]
    def artifactIdentifier: Option[String]
    def bucketOwnerAccess: Option[zio.aws.codebuild.model.BucketOwnerAccess]
    def getType: ZIO[Any, Nothing, zio.aws.codebuild.model.ArtifactsType] =
      ZIO.succeed(`type`)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getNamespaceType
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ArtifactNamespace] =
      AwsError.unwrapOptionField("namespaceType", namespaceType)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getPackaging
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ArtifactPackaging] =
      AwsError.unwrapOptionField("packaging", packaging)
    def getOverrideArtifactName: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("overrideArtifactName", overrideArtifactName)
    def getEncryptionDisabled: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("encryptionDisabled", encryptionDisabled)
    def getArtifactIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("artifactIdentifier", artifactIdentifier)
    def getBucketOwnerAccess
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BucketOwnerAccess] =
      AwsError.unwrapOptionField("bucketOwnerAccess", bucketOwnerAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectArtifacts
  ) extends zio.aws.codebuild.model.ProjectArtifacts.ReadOnly {
    override val `type`: zio.aws.codebuild.model.ArtifactsType =
      zio.aws.codebuild.model.ArtifactsType.wrap(impl.`type`())
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
    override val path: Option[String] =
      scala.Option(impl.path()).map(value => value: String)
    override val namespaceType
        : Option[zio.aws.codebuild.model.ArtifactNamespace] = scala
      .Option(impl.namespaceType())
      .map(value => zio.aws.codebuild.model.ArtifactNamespace.wrap(value))
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val packaging: Option[zio.aws.codebuild.model.ArtifactPackaging] =
      scala
        .Option(impl.packaging())
        .map(value => zio.aws.codebuild.model.ArtifactPackaging.wrap(value))
    override val overrideArtifactName: Option[WrapperBoolean] = scala
      .Option(impl.overrideArtifactName())
      .map(value => zio.aws.codebuild.model.primitives.WrapperBoolean(value))
    override val encryptionDisabled: Option[WrapperBoolean] = scala
      .Option(impl.encryptionDisabled())
      .map(value => zio.aws.codebuild.model.primitives.WrapperBoolean(value))
    override val artifactIdentifier: Option[String] =
      scala.Option(impl.artifactIdentifier()).map(value => value: String)
    override val bucketOwnerAccess
        : Option[zio.aws.codebuild.model.BucketOwnerAccess] = scala
      .Option(impl.bucketOwnerAccess())
      .map(value => zio.aws.codebuild.model.BucketOwnerAccess.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectArtifacts
  ): zio.aws.codebuild.model.ProjectArtifacts.ReadOnly = new Wrapper(impl)
}
