package zio.aws.codebuild
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.codebuild.model.primitives.{WrapperInt, NonEmptyString}
import zio.aws.codebuild.model.primitives.ProjectDescription.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object GitCloneDepth extends Subtype[Int]
    type GitCloneDepth = zio.aws.codebuild.model.primitives.GitCloneDepth.Type
    object KeyInput extends Subtype[String]
    type KeyInput = zio.aws.codebuild.model.primitives.KeyInput.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString = zio.aws.codebuild.model.primitives.NonEmptyString.Type
    object NonNegativeInt extends Subtype[Int]
    type NonNegativeInt = zio.aws.codebuild.model.primitives.NonNegativeInt.Type
    object PageSize extends Subtype[Int]
    type PageSize = zio.aws.codebuild.model.primitives.PageSize.Type
    object Percentage extends Subtype[Double]
    type Percentage = zio.aws.codebuild.model.primitives.Percentage.Type
    object ProjectDescription extends Subtype[String]
    type ProjectDescription =
      zio.aws.codebuild.model.primitives.ProjectDescription.Type
    object ProjectName extends Subtype[String]
    type ProjectName = zio.aws.codebuild.model.primitives.ProjectName.Type
    object ReportGroupName extends Subtype[String]
    type ReportGroupName =
      zio.aws.codebuild.model.primitives.ReportGroupName.Type
    object SensitiveNonEmptyString extends Subtype[String]
    type SensitiveNonEmptyString =
      zio.aws.codebuild.model.primitives.SensitiveNonEmptyString.Type
    object TimeOut extends Subtype[Int]
    type TimeOut = zio.aws.codebuild.model.primitives.TimeOut.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.codebuild.model.primitives.Timestamp.Type
    object ValueInput extends Subtype[String]
    type ValueInput = zio.aws.codebuild.model.primitives.ValueInput.Type
    object WrapperBoolean extends Subtype[Boolean]
    type WrapperBoolean = zio.aws.codebuild.model.primitives.WrapperBoolean.Type
    object WrapperInt extends Subtype[Int]
    type WrapperInt = zio.aws.codebuild.model.primitives.WrapperInt.Type
    object WrapperLong extends Subtype[Long]
    type WrapperLong = zio.aws.codebuild.model.primitives.WrapperLong.Type
  }
  type BuildArtifactsList = List[zio.aws.codebuild.model.BuildArtifacts]
  type BuildBatchIds = List[NonEmptyString]
  type BuildBatchPhases = List[zio.aws.codebuild.model.BuildBatchPhase]
  type BuildBatches = List[zio.aws.codebuild.model.BuildBatch]
  type BuildGroups = List[zio.aws.codebuild.model.BuildGroup]
  type BuildIds = List[NonEmptyString]
  type BuildPhases = List[zio.aws.codebuild.model.BuildPhase]
  type BuildReportArns = List[String]
  type BuildSummaries = List[zio.aws.codebuild.model.BuildSummary]
  type Builds = List[zio.aws.codebuild.model.Build]
  type BuildsNotDeleted = List[zio.aws.codebuild.model.BuildNotDeleted]
  type CodeCoverages = List[zio.aws.codebuild.model.CodeCoverage]
  type ComputeTypesAllowed = List[NonEmptyString]
  type EnvironmentImages = List[zio.aws.codebuild.model.EnvironmentImage]
  type EnvironmentLanguages = List[zio.aws.codebuild.model.EnvironmentLanguage]
  type EnvironmentPlatforms = List[zio.aws.codebuild.model.EnvironmentPlatform]
  type EnvironmentVariables = List[zio.aws.codebuild.model.EnvironmentVariable]
  type ExportedEnvironmentVariables =
    List[zio.aws.codebuild.model.ExportedEnvironmentVariable]
  type FilterGroup = List[zio.aws.codebuild.model.WebhookFilter]
  type FilterGroups = List[Iterable[zio.aws.codebuild.model.WebhookFilter]]
  type Identifiers = List[NonEmptyString]
  type ImageVersions = List[String]
  type PhaseContexts = List[zio.aws.codebuild.model.PhaseContext]
  type ProjectArns = List[NonEmptyString]
  type ProjectArtifactsList = List[zio.aws.codebuild.model.ProjectArtifacts]
  type ProjectCacheModes = List[zio.aws.codebuild.model.CacheMode]
  type ProjectFileSystemLocations =
    List[zio.aws.codebuild.model.ProjectFileSystemLocation]
  type ProjectNames = List[NonEmptyString]
  type ProjectSecondarySourceVersions =
    List[zio.aws.codebuild.model.ProjectSourceVersion]
  type ProjectSources = List[zio.aws.codebuild.model.ProjectSource]
  type Projects = List[zio.aws.codebuild.model.Project]
  type ReportArns = List[NonEmptyString]
  type ReportGroupArns = List[NonEmptyString]
  type ReportGroupTrendRawDataList =
    List[zio.aws.codebuild.model.ReportWithRawData]
  type ReportGroups = List[zio.aws.codebuild.model.ReportGroup]
  type ReportStatusCounts = Map[String, WrapperInt]
  type Reports = List[zio.aws.codebuild.model.Report]
  type ResolvedSecondaryArtifacts =
    List[zio.aws.codebuild.model.ResolvedArtifact]
  type SecurityGroupIds = List[NonEmptyString]
  type SourceCredentialsInfos =
    List[zio.aws.codebuild.model.SourceCredentialsInfo]
  type Subnets = List[NonEmptyString]
  type TagList = List[zio.aws.codebuild.model.Tag]
  type TestCases = List[zio.aws.codebuild.model.TestCase]
}
