package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait EnvironmentType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.EnvironmentType
}
object EnvironmentType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.EnvironmentType
  ): zio.aws.codebuild.model.EnvironmentType = value match {
    case software.amazon.awssdk.services.codebuild.model.EnvironmentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.EnvironmentType.WINDOWS_CONTAINER =>
      val r = WINDOWS_CONTAINER
      r
    case software.amazon.awssdk.services.codebuild.model.EnvironmentType.LINUX_CONTAINER =>
      val r = LINUX_CONTAINER
      r
    case software.amazon.awssdk.services.codebuild.model.EnvironmentType.LINUX_GPU_CONTAINER =>
      val r = LINUX_GPU_CONTAINER
      r
    case software.amazon.awssdk.services.codebuild.model.EnvironmentType.ARM_CONTAINER =>
      val r = ARM_CONTAINER
      r
    case software.amazon.awssdk.services.codebuild.model.EnvironmentType.WINDOWS_SERVER_2019_CONTAINER =>
      val r = WINDOWS_SERVER_2019_CONTAINER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.EnvironmentType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.EnvironmentType =
      software.amazon.awssdk.services.codebuild.model.EnvironmentType.UNKNOWN_TO_SDK_VERSION
  }
  case object WINDOWS_CONTAINER
      extends zio.aws.codebuild.model.EnvironmentType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.EnvironmentType =
      software.amazon.awssdk.services.codebuild.model.EnvironmentType.WINDOWS_CONTAINER
  }
  case object LINUX_CONTAINER extends zio.aws.codebuild.model.EnvironmentType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.EnvironmentType =
      software.amazon.awssdk.services.codebuild.model.EnvironmentType.LINUX_CONTAINER
  }
  case object LINUX_GPU_CONTAINER
      extends zio.aws.codebuild.model.EnvironmentType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.EnvironmentType =
      software.amazon.awssdk.services.codebuild.model.EnvironmentType.LINUX_GPU_CONTAINER
  }
  case object ARM_CONTAINER extends zio.aws.codebuild.model.EnvironmentType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.EnvironmentType =
      software.amazon.awssdk.services.codebuild.model.EnvironmentType.ARM_CONTAINER
  }
  case object WINDOWS_SERVER_2019_CONTAINER
      extends zio.aws.codebuild.model.EnvironmentType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.EnvironmentType =
      software.amazon.awssdk.services.codebuild.model.EnvironmentType.WINDOWS_SERVER_2019_CONTAINER
  }
}
