package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait WebhookFilterType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.WebhookFilterType
}
object WebhookFilterType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.WebhookFilterType
  ): zio.aws.codebuild.model.WebhookFilterType = value match {
    case software.amazon.awssdk.services.codebuild.model.WebhookFilterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.WebhookFilterType.EVENT =>
      val r = EVENT
      r
    case software.amazon.awssdk.services.codebuild.model.WebhookFilterType.BASE_REF =>
      val r = BASE_REF
      r
    case software.amazon.awssdk.services.codebuild.model.WebhookFilterType.HEAD_REF =>
      val r = HEAD_REF
      r
    case software.amazon.awssdk.services.codebuild.model.WebhookFilterType.ACTOR_ACCOUNT_ID =>
      val r = ACTOR_ACCOUNT_ID
      r
    case software.amazon.awssdk.services.codebuild.model.WebhookFilterType.FILE_PATH =>
      val r = FILE_PATH
      r
    case software.amazon.awssdk.services.codebuild.model.WebhookFilterType.COMMIT_MESSAGE =>
      val r = COMMIT_MESSAGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.WebhookFilterType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.WebhookFilterType =
      software.amazon.awssdk.services.codebuild.model.WebhookFilterType.UNKNOWN_TO_SDK_VERSION
  }
  case object EVENT extends zio.aws.codebuild.model.WebhookFilterType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.WebhookFilterType =
      software.amazon.awssdk.services.codebuild.model.WebhookFilterType.EVENT
  }
  case object BASE_REF extends zio.aws.codebuild.model.WebhookFilterType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.WebhookFilterType =
      software.amazon.awssdk.services.codebuild.model.WebhookFilterType.BASE_REF
  }
  case object HEAD_REF extends zio.aws.codebuild.model.WebhookFilterType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.WebhookFilterType =
      software.amazon.awssdk.services.codebuild.model.WebhookFilterType.HEAD_REF
  }
  case object ACTOR_ACCOUNT_ID
      extends zio.aws.codebuild.model.WebhookFilterType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.WebhookFilterType =
      software.amazon.awssdk.services.codebuild.model.WebhookFilterType.ACTOR_ACCOUNT_ID
  }
  case object FILE_PATH extends zio.aws.codebuild.model.WebhookFilterType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.WebhookFilterType =
      software.amazon.awssdk.services.codebuild.model.WebhookFilterType.FILE_PATH
  }
  case object COMMIT_MESSAGE extends zio.aws.codebuild.model.WebhookFilterType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.WebhookFilterType =
      software.amazon.awssdk.services.codebuild.model.WebhookFilterType.COMMIT_MESSAGE
  }
}
