package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait ArtifactsType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.ArtifactsType
}
object ArtifactsType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.ArtifactsType
  ): zio.aws.codebuild.model.ArtifactsType = value match {
    case software.amazon.awssdk.services.codebuild.model.ArtifactsType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.ArtifactsType.CODEPIPELINE =>
      val r = CODEPIPELINE
      r
    case software.amazon.awssdk.services.codebuild.model.ArtifactsType.S3 =>
      val r = S3
      r
    case software.amazon.awssdk.services.codebuild.model.ArtifactsType.NO_ARTIFACTS =>
      val r = NO_ARTIFACTS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.ArtifactsType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ArtifactsType =
      software.amazon.awssdk.services.codebuild.model.ArtifactsType.UNKNOWN_TO_SDK_VERSION
  }
  case object CODEPIPELINE extends zio.aws.codebuild.model.ArtifactsType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ArtifactsType =
      software.amazon.awssdk.services.codebuild.model.ArtifactsType.CODEPIPELINE
  }
  case object S3 extends zio.aws.codebuild.model.ArtifactsType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ArtifactsType =
      software.amazon.awssdk.services.codebuild.model.ArtifactsType.S3
  }
  case object NO_ARTIFACTS extends zio.aws.codebuild.model.ArtifactsType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ArtifactsType =
      software.amazon.awssdk.services.codebuild.model.ArtifactsType.NO_ARTIFACTS
  }
}
