package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait SourceType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.SourceType
}
object SourceType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.SourceType
  ): zio.aws.codebuild.model.SourceType = value match {
    case software.amazon.awssdk.services.codebuild.model.SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.SourceType.CODECOMMIT =>
      val r = CODECOMMIT
      r
    case software.amazon.awssdk.services.codebuild.model.SourceType.CODEPIPELINE =>
      val r = CODEPIPELINE
      r
    case software.amazon.awssdk.services.codebuild.model.SourceType.GITHUB =>
      val r = GITHUB
      r
    case software.amazon.awssdk.services.codebuild.model.SourceType.S3 =>
      val r = S3
      r
    case software.amazon.awssdk.services.codebuild.model.SourceType.BITBUCKET =>
      val r = BITBUCKET
      r
    case software.amazon.awssdk.services.codebuild.model.SourceType.GITHUB_ENTERPRISE =>
      val r = GITHUB_ENTERPRISE
      r
    case software.amazon.awssdk.services.codebuild.model.SourceType.NO_SOURCE =>
      val r = NO_SOURCE
      r
  }
  case object unknownToSdkVersion extends zio.aws.codebuild.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SourceType =
      software.amazon.awssdk.services.codebuild.model.SourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object CODECOMMIT extends zio.aws.codebuild.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SourceType =
      software.amazon.awssdk.services.codebuild.model.SourceType.CODECOMMIT
  }
  case object CODEPIPELINE extends zio.aws.codebuild.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SourceType =
      software.amazon.awssdk.services.codebuild.model.SourceType.CODEPIPELINE
  }
  case object GITHUB extends zio.aws.codebuild.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SourceType =
      software.amazon.awssdk.services.codebuild.model.SourceType.GITHUB
  }
  case object S3 extends zio.aws.codebuild.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SourceType =
      software.amazon.awssdk.services.codebuild.model.SourceType.S3
  }
  case object BITBUCKET extends zio.aws.codebuild.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SourceType =
      software.amazon.awssdk.services.codebuild.model.SourceType.BITBUCKET
  }
  case object GITHUB_ENTERPRISE extends zio.aws.codebuild.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SourceType =
      software.amazon.awssdk.services.codebuild.model.SourceType.GITHUB_ENTERPRISE
  }
  case object NO_SOURCE extends zio.aws.codebuild.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SourceType =
      software.amazon.awssdk.services.codebuild.model.SourceType.NO_SOURCE
  }
}
