package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{
  Timestamp,
  ReportGroupName,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ReportGroup(
    arn: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[ReportGroupName] = Optional.Absent,
    `type`: Optional[zio.aws.codebuild.model.ReportType] = Optional.Absent,
    exportConfig: Optional[zio.aws.codebuild.model.ReportExportConfig] =
      Optional.Absent,
    created: Optional[Timestamp] = Optional.Absent,
    lastModified: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.codebuild.model.Tag]] = Optional.Absent,
    status: Optional[zio.aws.codebuild.model.ReportGroupStatusType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ReportGroup = {
    import ReportGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ReportGroup
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ReportGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(exportConfig.map(value => value.buildAwsValue()))(
        _.exportConfig
      )
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(
        lastModified.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ReportGroup.ReadOnly =
    zio.aws.codebuild.model.ReportGroup.wrap(buildAwsValue())
}
object ReportGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ReportGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ReportGroup =
      zio.aws.codebuild.model.ReportGroup(
        arn.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        exportConfig.map(value => value.asEditable),
        created.map(value => value),
        lastModified.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value)
      )
    def arn: Optional[NonEmptyString]
    def name: Optional[ReportGroupName]
    def `type`: Optional[zio.aws.codebuild.model.ReportType]
    def exportConfig
        : Optional[zio.aws.codebuild.model.ReportExportConfig.ReadOnly]
    def created: Optional[Timestamp]
    def lastModified: Optional[Timestamp]
    def tags: Optional[List[zio.aws.codebuild.model.Tag.ReadOnly]]
    def status: Optional[zio.aws.codebuild.model.ReportGroupStatusType]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ReportGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.codebuild.model.ReportType] =
      AwsError.unwrapOptionField("type", `type`)
    def getExportConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ReportExportConfig.ReadOnly
    ] = AwsError.unwrapOptionField("exportConfig", exportConfig)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getLastModified: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codebuild.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ReportGroupStatusType] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ReportGroup
  ) extends zio.aws.codebuild.model.ReportGroup.ReadOnly {
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val name: Optional[ReportGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codebuild.model.primitives.ReportGroupName(value))
    override val `type`: Optional[zio.aws.codebuild.model.ReportType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.codebuild.model.ReportType.wrap(value))
    override val exportConfig
        : Optional[zio.aws.codebuild.model.ReportExportConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportConfig())
        .map(value => zio.aws.codebuild.model.ReportExportConfig.wrap(value))
    override val created: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val lastModified: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val tags: Optional[List[zio.aws.codebuild.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.Tag.wrap(item)
          }.toList
        )
    override val status
        : Optional[zio.aws.codebuild.model.ReportGroupStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codebuild.model.ReportGroupStatusType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ReportGroup
  ): zio.aws.codebuild.model.ReportGroup.ReadOnly = new Wrapper(impl)
}
