package zio.aws.codebuild
import zio.aws.codebuild.model.ListProjectsResponse.ReadOnly
import zio.aws.codebuild.model.primitives.NonEmptyString
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient
import zio.aws.codebuild.model.{
  ListSharedProjectsRequest,
  ListReportGroupsRequest,
  BatchGetReportsRequest,
  ImportSourceCredentialsRequest,
  BatchGetBuildsRequest,
  ListBuildsForProjectRequest,
  InvalidateProjectCacheRequest,
  CreateProjectRequest,
  BatchGetReportGroupsRequest,
  DeleteSourceCredentialsRequest,
  StopBuildRequest,
  StartBuildRequest,
  ListSourceCredentialsRequest,
  PutResourcePolicyRequest,
  DescribeCodeCoveragesRequest,
  ListBuildBatchesForProjectRequest,
  CreateWebhookRequest,
  ListCuratedEnvironmentImagesRequest,
  DeleteReportGroupRequest,
  RetryBuildBatchRequest,
  ListReportsForReportGroupRequest,
  ListBuildsRequest,
  UpdateProjectRequest,
  BatchGetProjectsRequest,
  DeleteReportRequest,
  UpdateReportGroupRequest,
  DeleteProjectRequest,
  UpdateProjectVisibilityRequest,
  ListBuildBatchesRequest,
  ListReportsRequest,
  GetReportGroupTrendRequest,
  StopBuildBatchRequest,
  DeleteResourcePolicyRequest,
  DeleteWebhookRequest,
  ListProjectsRequest,
  RetryBuildRequest,
  BatchGetBuildBatchesRequest,
  BatchDeleteBuildsRequest,
  GetResourcePolicyRequest,
  DeleteBuildBatchRequest,
  StartBuildBatchRequest,
  DescribeTestCasesRequest,
  UpdateWebhookRequest,
  ListSharedReportGroupsRequest,
  CreateReportGroupRequest
}
import zio.stream.ZStream
object CodeBuildMock extends Mock[CodeBuild] {
  object BatchGetBuilds
      extends Effect[
        BatchGetBuildsRequest,
        AwsError,
        zio.aws.codebuild.model.BatchGetBuildsResponse.ReadOnly
      ]
  object GetReportGroupTrend
      extends Effect[
        GetReportGroupTrendRequest,
        AwsError,
        zio.aws.codebuild.model.GetReportGroupTrendResponse.ReadOnly
      ]
  object UpdateReportGroup
      extends Effect[
        UpdateReportGroupRequest,
        AwsError,
        zio.aws.codebuild.model.UpdateReportGroupResponse.ReadOnly
      ]
  object BatchGetBuildBatches
      extends Effect[
        BatchGetBuildBatchesRequest,
        AwsError,
        zio.aws.codebuild.model.BatchGetBuildBatchesResponse.ReadOnly
      ]
  object BatchDeleteBuilds
      extends Effect[
        BatchDeleteBuildsRequest,
        AwsError,
        zio.aws.codebuild.model.BatchDeleteBuildsResponse.ReadOnly
      ]
  object ListCuratedEnvironmentImages
      extends Effect[
        ListCuratedEnvironmentImagesRequest,
        AwsError,
        zio.aws.codebuild.model.ListCuratedEnvironmentImagesResponse.ReadOnly
      ]
  object RetryBuild
      extends Effect[
        RetryBuildRequest,
        AwsError,
        zio.aws.codebuild.model.RetryBuildResponse.ReadOnly
      ]
  object UpdateProject
      extends Effect[
        UpdateProjectRequest,
        AwsError,
        zio.aws.codebuild.model.UpdateProjectResponse.ReadOnly
      ]
  object BatchGetProjects
      extends Effect[
        BatchGetProjectsRequest,
        AwsError,
        zio.aws.codebuild.model.BatchGetProjectsResponse.ReadOnly
      ]
  object ListReportsForReportGroup
      extends Stream[ListReportsForReportGroupRequest, AwsError, NonEmptyString]
  object ListReportsForReportGroupPaginated
      extends Effect[
        ListReportsForReportGroupRequest,
        AwsError,
        zio.aws.codebuild.model.ListReportsForReportGroupResponse.ReadOnly
      ]
  object StopBuild
      extends Effect[
        StopBuildRequest,
        AwsError,
        zio.aws.codebuild.model.StopBuildResponse.ReadOnly
      ]
  object ListBuildsForProject
      extends Stream[ListBuildsForProjectRequest, AwsError, NonEmptyString]
  object ListBuildsForProjectPaginated
      extends Effect[
        ListBuildsForProjectRequest,
        AwsError,
        zio.aws.codebuild.model.ListBuildsForProjectResponse.ReadOnly
      ]
  object DeleteReportGroup
      extends Effect[
        DeleteReportGroupRequest,
        AwsError,
        zio.aws.codebuild.model.DeleteReportGroupResponse.ReadOnly
      ]
  object DescribeTestCases
      extends Stream[
        DescribeTestCasesRequest,
        AwsError,
        zio.aws.codebuild.model.TestCase.ReadOnly
      ]
  object DescribeTestCasesPaginated
      extends Effect[
        DescribeTestCasesRequest,
        AwsError,
        zio.aws.codebuild.model.DescribeTestCasesResponse.ReadOnly
      ]
  object ListBuildBatchesForProject
      extends Stream[
        ListBuildBatchesForProjectRequest,
        AwsError,
        NonEmptyString
      ]
  object ListBuildBatchesForProjectPaginated
      extends Effect[
        ListBuildBatchesForProjectRequest,
        AwsError,
        zio.aws.codebuild.model.ListBuildBatchesForProjectResponse.ReadOnly
      ]
  object DeleteWebhook
      extends Effect[
        DeleteWebhookRequest,
        AwsError,
        zio.aws.codebuild.model.DeleteWebhookResponse.ReadOnly
      ]
  object PutResourcePolicy
      extends Effect[
        PutResourcePolicyRequest,
        AwsError,
        zio.aws.codebuild.model.PutResourcePolicyResponse.ReadOnly
      ]
  object ListReportGroups
      extends Stream[ListReportGroupsRequest, AwsError, NonEmptyString]
  object ListReportGroupsPaginated
      extends Effect[
        ListReportGroupsRequest,
        AwsError,
        zio.aws.codebuild.model.ListReportGroupsResponse.ReadOnly
      ]
  object ListProjects
      extends Stream[ListProjectsRequest, AwsError, NonEmptyString]
  object ListProjectsPaginated
      extends Effect[ListProjectsRequest, AwsError, ReadOnly]
  object UpdateWebhook
      extends Effect[
        UpdateWebhookRequest,
        AwsError,
        zio.aws.codebuild.model.UpdateWebhookResponse.ReadOnly
      ]
  object ImportSourceCredentials
      extends Effect[
        ImportSourceCredentialsRequest,
        AwsError,
        zio.aws.codebuild.model.ImportSourceCredentialsResponse.ReadOnly
      ]
  object InvalidateProjectCache
      extends Effect[
        InvalidateProjectCacheRequest,
        AwsError,
        zio.aws.codebuild.model.InvalidateProjectCacheResponse.ReadOnly
      ]
  object BatchGetReportGroups
      extends Effect[
        BatchGetReportGroupsRequest,
        AwsError,
        zio.aws.codebuild.model.BatchGetReportGroupsResponse.ReadOnly
      ]
  object CreateReportGroup
      extends Effect[
        CreateReportGroupRequest,
        AwsError,
        zio.aws.codebuild.model.CreateReportGroupResponse.ReadOnly
      ]
  object CreateProject
      extends Effect[
        CreateProjectRequest,
        AwsError,
        zio.aws.codebuild.model.CreateProjectResponse.ReadOnly
      ]
  object StartBuild
      extends Effect[
        StartBuildRequest,
        AwsError,
        zio.aws.codebuild.model.StartBuildResponse.ReadOnly
      ]
  object DeleteBuildBatch
      extends Effect[
        DeleteBuildBatchRequest,
        AwsError,
        zio.aws.codebuild.model.DeleteBuildBatchResponse.ReadOnly
      ]
  object ListSharedReportGroups
      extends Stream[ListSharedReportGroupsRequest, AwsError, NonEmptyString]
  object ListSharedReportGroupsPaginated
      extends Effect[
        ListSharedReportGroupsRequest,
        AwsError,
        zio.aws.codebuild.model.ListSharedReportGroupsResponse.ReadOnly
      ]
  object DeleteResourcePolicy
      extends Effect[
        DeleteResourcePolicyRequest,
        AwsError,
        zio.aws.codebuild.model.DeleteResourcePolicyResponse.ReadOnly
      ]
  object StopBuildBatch
      extends Effect[
        StopBuildBatchRequest,
        AwsError,
        zio.aws.codebuild.model.StopBuildBatchResponse.ReadOnly
      ]
  object StartBuildBatch
      extends Effect[
        StartBuildBatchRequest,
        AwsError,
        zio.aws.codebuild.model.StartBuildBatchResponse.ReadOnly
      ]
  object BatchGetReports
      extends Effect[
        BatchGetReportsRequest,
        AwsError,
        zio.aws.codebuild.model.BatchGetReportsResponse.ReadOnly
      ]
  object UpdateProjectVisibility
      extends Effect[
        UpdateProjectVisibilityRequest,
        AwsError,
        zio.aws.codebuild.model.UpdateProjectVisibilityResponse.ReadOnly
      ]
  object CreateWebhook
      extends Effect[
        CreateWebhookRequest,
        AwsError,
        zio.aws.codebuild.model.CreateWebhookResponse.ReadOnly
      ]
  object DeleteSourceCredentials
      extends Effect[
        DeleteSourceCredentialsRequest,
        AwsError,
        zio.aws.codebuild.model.DeleteSourceCredentialsResponse.ReadOnly
      ]
  object ListSharedProjects
      extends Stream[ListSharedProjectsRequest, AwsError, NonEmptyString]
  object ListSharedProjectsPaginated
      extends Effect[
        ListSharedProjectsRequest,
        AwsError,
        zio.aws.codebuild.model.ListSharedProjectsResponse.ReadOnly
      ]
  object RetryBuildBatch
      extends Effect[
        RetryBuildBatchRequest,
        AwsError,
        zio.aws.codebuild.model.RetryBuildBatchResponse.ReadOnly
      ]
  object ListSourceCredentials
      extends Effect[
        ListSourceCredentialsRequest,
        AwsError,
        zio.aws.codebuild.model.ListSourceCredentialsResponse.ReadOnly
      ]
  object ListReports
      extends Stream[ListReportsRequest, AwsError, NonEmptyString]
  object ListReportsPaginated
      extends Effect[
        ListReportsRequest,
        AwsError,
        zio.aws.codebuild.model.ListReportsResponse.ReadOnly
      ]
  object GetResourcePolicy
      extends Effect[
        GetResourcePolicyRequest,
        AwsError,
        zio.aws.codebuild.model.GetResourcePolicyResponse.ReadOnly
      ]
  object DeleteProject
      extends Effect[
        DeleteProjectRequest,
        AwsError,
        zio.aws.codebuild.model.DeleteProjectResponse.ReadOnly
      ]
  object ListBuilds extends Stream[ListBuildsRequest, AwsError, NonEmptyString]
  object ListBuildsPaginated
      extends Effect[
        ListBuildsRequest,
        AwsError,
        zio.aws.codebuild.model.ListBuildsResponse.ReadOnly
      ]
  object DeleteReport
      extends Effect[
        DeleteReportRequest,
        AwsError,
        zio.aws.codebuild.model.DeleteReportResponse.ReadOnly
      ]
  object DescribeCodeCoverages
      extends Stream[
        DescribeCodeCoveragesRequest,
        AwsError,
        zio.aws.codebuild.model.CodeCoverage.ReadOnly
      ]
  object DescribeCodeCoveragesPaginated
      extends Effect[
        DescribeCodeCoveragesRequest,
        AwsError,
        zio.aws.codebuild.model.DescribeCodeCoveragesResponse.ReadOnly
      ]
  object ListBuildBatches
      extends Stream[ListBuildBatchesRequest, AwsError, NonEmptyString]
  object ListBuildBatchesPaginated
      extends Effect[
        ListBuildBatchesRequest,
        AwsError,
        zio.aws.codebuild.model.ListBuildBatchesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CodeBuild] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CodeBuild] { rts =>
        zio.ZIO.succeed {
          new CodeBuild {
            val api: CodeBuildAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CodeBuild = this
            def batchGetBuilds(request: BatchGetBuildsRequest): IO[
              AwsError,
              zio.aws.codebuild.model.BatchGetBuildsResponse.ReadOnly
            ] = proxy(BatchGetBuilds, request)
            def getReportGroupTrend(request: GetReportGroupTrendRequest): IO[
              AwsError,
              zio.aws.codebuild.model.GetReportGroupTrendResponse.ReadOnly
            ] = proxy(GetReportGroupTrend, request)
            def updateReportGroup(request: UpdateReportGroupRequest): IO[
              AwsError,
              zio.aws.codebuild.model.UpdateReportGroupResponse.ReadOnly
            ] = proxy(UpdateReportGroup, request)
            def batchGetBuildBatches(request: BatchGetBuildBatchesRequest): IO[
              AwsError,
              zio.aws.codebuild.model.BatchGetBuildBatchesResponse.ReadOnly
            ] = proxy(BatchGetBuildBatches, request)
            def batchDeleteBuilds(request: BatchDeleteBuildsRequest): IO[
              AwsError,
              zio.aws.codebuild.model.BatchDeleteBuildsResponse.ReadOnly
            ] = proxy(BatchDeleteBuilds, request)
            def listCuratedEnvironmentImages(
                request: ListCuratedEnvironmentImagesRequest
            ): IO[
              AwsError,
              zio.aws.codebuild.model.ListCuratedEnvironmentImagesResponse.ReadOnly
            ] = proxy(ListCuratedEnvironmentImages, request)
            def retryBuild(request: RetryBuildRequest): IO[
              AwsError,
              zio.aws.codebuild.model.RetryBuildResponse.ReadOnly
            ] = proxy(RetryBuild, request)
            def updateProject(request: UpdateProjectRequest): IO[
              AwsError,
              zio.aws.codebuild.model.UpdateProjectResponse.ReadOnly
            ] = proxy(UpdateProject, request)
            def batchGetProjects(request: BatchGetProjectsRequest): IO[
              AwsError,
              zio.aws.codebuild.model.BatchGetProjectsResponse.ReadOnly
            ] = proxy(BatchGetProjects, request)
            def listReportsForReportGroup(
                request: ListReportsForReportGroupRequest
            ): ZStream[Any, AwsError, NonEmptyString] =
              rts.unsafeRun(proxy(ListReportsForReportGroup, request))
            def listReportsForReportGroupPaginated(
                request: ListReportsForReportGroupRequest
            ): IO[
              AwsError,
              zio.aws.codebuild.model.ListReportsForReportGroupResponse.ReadOnly
            ] = proxy(ListReportsForReportGroupPaginated, request)
            def stopBuild(request: StopBuildRequest): IO[
              AwsError,
              zio.aws.codebuild.model.StopBuildResponse.ReadOnly
            ] = proxy(StopBuild, request)
            def listBuildsForProject(
                request: ListBuildsForProjectRequest
            ): ZStream[Any, AwsError, NonEmptyString] =
              rts.unsafeRun(proxy(ListBuildsForProject, request))
            def listBuildsForProjectPaginated(
                request: ListBuildsForProjectRequest
            ): IO[
              AwsError,
              zio.aws.codebuild.model.ListBuildsForProjectResponse.ReadOnly
            ] = proxy(ListBuildsForProjectPaginated, request)
            def deleteReportGroup(request: DeleteReportGroupRequest): IO[
              AwsError,
              zio.aws.codebuild.model.DeleteReportGroupResponse.ReadOnly
            ] = proxy(DeleteReportGroup, request)
            def describeTestCases(request: DescribeTestCasesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codebuild.model.TestCase.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeTestCases, request))
            def describeTestCasesPaginated(
                request: DescribeTestCasesRequest
            ): IO[
              AwsError,
              zio.aws.codebuild.model.DescribeTestCasesResponse.ReadOnly
            ] = proxy(DescribeTestCasesPaginated, request)
            def listBuildBatchesForProject(
                request: ListBuildBatchesForProjectRequest
            ): ZStream[Any, AwsError, NonEmptyString] =
              rts.unsafeRun(proxy(ListBuildBatchesForProject, request))
            def listBuildBatchesForProjectPaginated(
                request: ListBuildBatchesForProjectRequest
            ): IO[
              AwsError,
              zio.aws.codebuild.model.ListBuildBatchesForProjectResponse.ReadOnly
            ] = proxy(ListBuildBatchesForProjectPaginated, request)
            def deleteWebhook(request: DeleteWebhookRequest): IO[
              AwsError,
              zio.aws.codebuild.model.DeleteWebhookResponse.ReadOnly
            ] = proxy(DeleteWebhook, request)
            def putResourcePolicy(request: PutResourcePolicyRequest): IO[
              AwsError,
              zio.aws.codebuild.model.PutResourcePolicyResponse.ReadOnly
            ] = proxy(PutResourcePolicy, request)
            def listReportGroups(
                request: ListReportGroupsRequest
            ): ZStream[Any, AwsError, NonEmptyString] =
              rts.unsafeRun(proxy(ListReportGroups, request))
            def listReportGroupsPaginated(request: ListReportGroupsRequest): IO[
              AwsError,
              zio.aws.codebuild.model.ListReportGroupsResponse.ReadOnly
            ] = proxy(ListReportGroupsPaginated, request)
            def listProjects(
                request: ListProjectsRequest
            ): ZStream[Any, AwsError, NonEmptyString] =
              rts.unsafeRun(proxy(ListProjects, request))
            def listProjectsPaginated(
                request: ListProjectsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListProjectsPaginated, request)
            def updateWebhook(request: UpdateWebhookRequest): IO[
              AwsError,
              zio.aws.codebuild.model.UpdateWebhookResponse.ReadOnly
            ] = proxy(UpdateWebhook, request)
            def importSourceCredentials(
                request: ImportSourceCredentialsRequest
            ): IO[
              AwsError,
              zio.aws.codebuild.model.ImportSourceCredentialsResponse.ReadOnly
            ] = proxy(ImportSourceCredentials, request)
            def invalidateProjectCache(
                request: InvalidateProjectCacheRequest
            ): IO[
              AwsError,
              zio.aws.codebuild.model.InvalidateProjectCacheResponse.ReadOnly
            ] = proxy(InvalidateProjectCache, request)
            def batchGetReportGroups(request: BatchGetReportGroupsRequest): IO[
              AwsError,
              zio.aws.codebuild.model.BatchGetReportGroupsResponse.ReadOnly
            ] = proxy(BatchGetReportGroups, request)
            def createReportGroup(request: CreateReportGroupRequest): IO[
              AwsError,
              zio.aws.codebuild.model.CreateReportGroupResponse.ReadOnly
            ] = proxy(CreateReportGroup, request)
            def createProject(request: CreateProjectRequest): IO[
              AwsError,
              zio.aws.codebuild.model.CreateProjectResponse.ReadOnly
            ] = proxy(CreateProject, request)
            def startBuild(request: StartBuildRequest): IO[
              AwsError,
              zio.aws.codebuild.model.StartBuildResponse.ReadOnly
            ] = proxy(StartBuild, request)
            def deleteBuildBatch(request: DeleteBuildBatchRequest): IO[
              AwsError,
              zio.aws.codebuild.model.DeleteBuildBatchResponse.ReadOnly
            ] = proxy(DeleteBuildBatch, request)
            def listSharedReportGroups(
                request: ListSharedReportGroupsRequest
            ): ZStream[Any, AwsError, NonEmptyString] =
              rts.unsafeRun(proxy(ListSharedReportGroups, request))
            def listSharedReportGroupsPaginated(
                request: ListSharedReportGroupsRequest
            ): IO[
              AwsError,
              zio.aws.codebuild.model.ListSharedReportGroupsResponse.ReadOnly
            ] = proxy(ListSharedReportGroupsPaginated, request)
            def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
              AwsError,
              zio.aws.codebuild.model.DeleteResourcePolicyResponse.ReadOnly
            ] = proxy(DeleteResourcePolicy, request)
            def stopBuildBatch(request: StopBuildBatchRequest): IO[
              AwsError,
              zio.aws.codebuild.model.StopBuildBatchResponse.ReadOnly
            ] = proxy(StopBuildBatch, request)
            def startBuildBatch(request: StartBuildBatchRequest): IO[
              AwsError,
              zio.aws.codebuild.model.StartBuildBatchResponse.ReadOnly
            ] = proxy(StartBuildBatch, request)
            def batchGetReports(request: BatchGetReportsRequest): IO[
              AwsError,
              zio.aws.codebuild.model.BatchGetReportsResponse.ReadOnly
            ] = proxy(BatchGetReports, request)
            def updateProjectVisibility(
                request: UpdateProjectVisibilityRequest
            ): IO[
              AwsError,
              zio.aws.codebuild.model.UpdateProjectVisibilityResponse.ReadOnly
            ] = proxy(UpdateProjectVisibility, request)
            def createWebhook(request: CreateWebhookRequest): IO[
              AwsError,
              zio.aws.codebuild.model.CreateWebhookResponse.ReadOnly
            ] = proxy(CreateWebhook, request)
            def deleteSourceCredentials(
                request: DeleteSourceCredentialsRequest
            ): IO[
              AwsError,
              zio.aws.codebuild.model.DeleteSourceCredentialsResponse.ReadOnly
            ] = proxy(DeleteSourceCredentials, request)
            def listSharedProjects(
                request: ListSharedProjectsRequest
            ): ZStream[Any, AwsError, NonEmptyString] =
              rts.unsafeRun(proxy(ListSharedProjects, request))
            def listSharedProjectsPaginated(
                request: ListSharedProjectsRequest
            ): IO[
              AwsError,
              zio.aws.codebuild.model.ListSharedProjectsResponse.ReadOnly
            ] = proxy(ListSharedProjectsPaginated, request)
            def retryBuildBatch(request: RetryBuildBatchRequest): IO[
              AwsError,
              zio.aws.codebuild.model.RetryBuildBatchResponse.ReadOnly
            ] = proxy(RetryBuildBatch, request)
            def listSourceCredentials(
                request: ListSourceCredentialsRequest
            ): IO[
              AwsError,
              zio.aws.codebuild.model.ListSourceCredentialsResponse.ReadOnly
            ] = proxy(ListSourceCredentials, request)
            def listReports(
                request: ListReportsRequest
            ): ZStream[Any, AwsError, NonEmptyString] =
              rts.unsafeRun(proxy(ListReports, request))
            def listReportsPaginated(request: ListReportsRequest): IO[
              AwsError,
              zio.aws.codebuild.model.ListReportsResponse.ReadOnly
            ] = proxy(ListReportsPaginated, request)
            def getResourcePolicy(request: GetResourcePolicyRequest): IO[
              AwsError,
              zio.aws.codebuild.model.GetResourcePolicyResponse.ReadOnly
            ] = proxy(GetResourcePolicy, request)
            def deleteProject(request: DeleteProjectRequest): IO[
              AwsError,
              zio.aws.codebuild.model.DeleteProjectResponse.ReadOnly
            ] = proxy(DeleteProject, request)
            def listBuilds(
                request: ListBuildsRequest
            ): ZStream[Any, AwsError, NonEmptyString] =
              rts.unsafeRun(proxy(ListBuilds, request))
            def listBuildsPaginated(request: ListBuildsRequest): IO[
              AwsError,
              zio.aws.codebuild.model.ListBuildsResponse.ReadOnly
            ] = proxy(ListBuildsPaginated, request)
            def deleteReport(request: DeleteReportRequest): IO[
              AwsError,
              zio.aws.codebuild.model.DeleteReportResponse.ReadOnly
            ] = proxy(DeleteReport, request)
            def describeCodeCoverages(
                request: DescribeCodeCoveragesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codebuild.model.CodeCoverage.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeCodeCoverages, request))
            def describeCodeCoveragesPaginated(
                request: DescribeCodeCoveragesRequest
            ): IO[
              AwsError,
              zio.aws.codebuild.model.DescribeCodeCoveragesResponse.ReadOnly
            ] = proxy(DescribeCodeCoveragesPaginated, request)
            def listBuildBatches(
                request: ListBuildBatchesRequest
            ): ZStream[Any, AwsError, NonEmptyString] =
              rts.unsafeRun(proxy(ListBuildBatches, request))
            def listBuildBatchesPaginated(request: ListBuildBatchesRequest): IO[
              AwsError,
              zio.aws.codebuild.model.ListBuildBatchesResponse.ReadOnly
            ] = proxy(ListBuildBatchesPaginated, request)
          }
        }
      }
    }
  }
}
