package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait ReportGroupStatusType {
  def unwrap
      : software.amazon.awssdk.services.codebuild.model.ReportGroupStatusType
}
object ReportGroupStatusType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.ReportGroupStatusType
  ): zio.aws.codebuild.model.ReportGroupStatusType = value match {
    case software.amazon.awssdk.services.codebuild.model.ReportGroupStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.ReportGroupStatusType.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.codebuild.model.ReportGroupStatusType.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.ReportGroupStatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportGroupStatusType =
      software.amazon.awssdk.services.codebuild.model.ReportGroupStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.codebuild.model.ReportGroupStatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportGroupStatusType =
      software.amazon.awssdk.services.codebuild.model.ReportGroupStatusType.ACTIVE
  }
  case object DELETING extends zio.aws.codebuild.model.ReportGroupStatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportGroupStatusType =
      software.amazon.awssdk.services.codebuild.model.ReportGroupStatusType.DELETING
  }
}
