package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait ProjectSortByType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.ProjectSortByType
}
object ProjectSortByType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.ProjectSortByType
  ): zio.aws.codebuild.model.ProjectSortByType = value match {
    case software.amazon.awssdk.services.codebuild.model.ProjectSortByType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.ProjectSortByType.NAME =>
      val r = NAME
      r
    case software.amazon.awssdk.services.codebuild.model.ProjectSortByType.CREATED_TIME =>
      val r = CREATED_TIME
      r
    case software.amazon.awssdk.services.codebuild.model.ProjectSortByType.LAST_MODIFIED_TIME =>
      val r = LAST_MODIFIED_TIME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.ProjectSortByType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ProjectSortByType =
      software.amazon.awssdk.services.codebuild.model.ProjectSortByType.UNKNOWN_TO_SDK_VERSION
  }
  case object NAME extends zio.aws.codebuild.model.ProjectSortByType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ProjectSortByType =
      software.amazon.awssdk.services.codebuild.model.ProjectSortByType.NAME
  }
  case object CREATED_TIME extends zio.aws.codebuild.model.ProjectSortByType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ProjectSortByType =
      software.amazon.awssdk.services.codebuild.model.ProjectSortByType.CREATED_TIME
  }
  case object LAST_MODIFIED_TIME
      extends zio.aws.codebuild.model.ProjectSortByType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ProjectSortByType =
      software.amazon.awssdk.services.codebuild.model.ProjectSortByType.LAST_MODIFIED_TIME
  }
}
