package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait EnvironmentVariableType {
  def unwrap
      : software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType
}
object EnvironmentVariableType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType
  ): zio.aws.codebuild.model.EnvironmentVariableType = value match {
    case software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType.PLAINTEXT =>
      val r = PLAINTEXT
      r
    case software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType.PARAMETER_STORE =>
      val r = PARAMETER_STORE
      r
    case software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType.SECRETS_MANAGER =>
      val r = SECRETS_MANAGER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.EnvironmentVariableType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType =
      software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType.UNKNOWN_TO_SDK_VERSION
  }
  case object PLAINTEXT
      extends zio.aws.codebuild.model.EnvironmentVariableType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType =
      software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType.PLAINTEXT
  }
  case object PARAMETER_STORE
      extends zio.aws.codebuild.model.EnvironmentVariableType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType =
      software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType.PARAMETER_STORE
  }
  case object SECRETS_MANAGER
      extends zio.aws.codebuild.model.EnvironmentVariableType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType =
      software.amazon.awssdk.services.codebuild.model.EnvironmentVariableType.SECRETS_MANAGER
  }
}
