package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{
  ProjectName,
  WrapperBoolean,
  ProjectDescription,
  WrapperInt,
  TimeOut,
  NonEmptyString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateProjectRequest(
    name: ProjectName,
    description: Optional[ProjectDescription] = Optional.Absent,
    source: zio.aws.codebuild.model.ProjectSource,
    secondarySources: Optional[
      Iterable[zio.aws.codebuild.model.ProjectSource]
    ] = Optional.Absent,
    sourceVersion: Optional[String] = Optional.Absent,
    secondarySourceVersions: Optional[
      Iterable[zio.aws.codebuild.model.ProjectSourceVersion]
    ] = Optional.Absent,
    artifacts: zio.aws.codebuild.model.ProjectArtifacts,
    secondaryArtifacts: Optional[
      Iterable[zio.aws.codebuild.model.ProjectArtifacts]
    ] = Optional.Absent,
    cache: Optional[zio.aws.codebuild.model.ProjectCache] = Optional.Absent,
    environment: zio.aws.codebuild.model.ProjectEnvironment,
    serviceRole: NonEmptyString,
    timeoutInMinutes: Optional[TimeOut] = Optional.Absent,
    queuedTimeoutInMinutes: Optional[TimeOut] = Optional.Absent,
    encryptionKey: Optional[NonEmptyString] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.codebuild.model.Tag]] = Optional.Absent,
    vpcConfig: Optional[zio.aws.codebuild.model.VpcConfig] = Optional.Absent,
    badgeEnabled: Optional[WrapperBoolean] = Optional.Absent,
    logsConfig: Optional[zio.aws.codebuild.model.LogsConfig] = Optional.Absent,
    fileSystemLocations: Optional[
      Iterable[zio.aws.codebuild.model.ProjectFileSystemLocation]
    ] = Optional.Absent,
    buildBatchConfig: Optional[
      zio.aws.codebuild.model.ProjectBuildBatchConfig
    ] = Optional.Absent,
    concurrentBuildLimit: Optional[WrapperInt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.CreateProjectRequest = {
    import CreateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.CreateProjectRequest
      .builder()
      .name(ProjectName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ProjectDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .source(source.buildAwsValue())
      .optionallyWith(
        secondarySources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySources)
      .optionallyWith(sourceVersion.map(value => value: java.lang.String))(
        _.sourceVersion
      )
      .optionallyWith(
        secondarySourceVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySourceVersions)
      .artifacts(artifacts.buildAwsValue())
      .optionallyWith(
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondaryArtifacts)
      .optionallyWith(cache.map(value => value.buildAwsValue()))(_.cache)
      .environment(environment.buildAwsValue())
      .serviceRole(NonEmptyString.unwrap(serviceRole): java.lang.String)
      .optionallyWith(
        timeoutInMinutes.map(value => TimeOut.unwrap(value): Integer)
      )(_.timeoutInMinutes)
      .optionallyWith(
        queuedTimeoutInMinutes.map(value => TimeOut.unwrap(value): Integer)
      )(_.queuedTimeoutInMinutes)
      .optionallyWith(
        encryptionKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKey)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(badgeEnabled.map(value => value: java.lang.Boolean))(
        _.badgeEnabled
      )
      .optionallyWith(logsConfig.map(value => value.buildAwsValue()))(
        _.logsConfig
      )
      .optionallyWith(
        fileSystemLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemLocations)
      .optionallyWith(buildBatchConfig.map(value => value.buildAwsValue()))(
        _.buildBatchConfig
      )
      .optionallyWith(concurrentBuildLimit.map(value => value: Integer))(
        _.concurrentBuildLimit
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.CreateProjectRequest.ReadOnly =
    zio.aws.codebuild.model.CreateProjectRequest.wrap(buildAwsValue())
}
object CreateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.CreateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.CreateProjectRequest =
      zio.aws.codebuild.model.CreateProjectRequest(
        name,
        description.map(value => value),
        source.asEditable,
        secondarySources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceVersion.map(value => value),
        secondarySourceVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        artifacts.asEditable,
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cache.map(value => value.asEditable),
        environment.asEditable,
        serviceRole,
        timeoutInMinutes.map(value => value),
        queuedTimeoutInMinutes.map(value => value),
        encryptionKey.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcConfig.map(value => value.asEditable),
        badgeEnabled.map(value => value),
        logsConfig.map(value => value.asEditable),
        fileSystemLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        buildBatchConfig.map(value => value.asEditable),
        concurrentBuildLimit.map(value => value)
      )
    def name: ProjectName
    def description: Optional[ProjectDescription]
    def source: zio.aws.codebuild.model.ProjectSource.ReadOnly
    def secondarySources
        : Optional[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]]
    def sourceVersion: Optional[String]
    def secondarySourceVersions
        : Optional[List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]]
    def artifacts: zio.aws.codebuild.model.ProjectArtifacts.ReadOnly
    def secondaryArtifacts
        : Optional[List[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly]]
    def cache: Optional[zio.aws.codebuild.model.ProjectCache.ReadOnly]
    def environment: zio.aws.codebuild.model.ProjectEnvironment.ReadOnly
    def serviceRole: NonEmptyString
    def timeoutInMinutes: Optional[TimeOut]
    def queuedTimeoutInMinutes: Optional[TimeOut]
    def encryptionKey: Optional[NonEmptyString]
    def tags: Optional[List[zio.aws.codebuild.model.Tag.ReadOnly]]
    def vpcConfig: Optional[zio.aws.codebuild.model.VpcConfig.ReadOnly]
    def badgeEnabled: Optional[WrapperBoolean]
    def logsConfig: Optional[zio.aws.codebuild.model.LogsConfig.ReadOnly]
    def fileSystemLocations: Optional[
      List[zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly]
    ]
    def buildBatchConfig
        : Optional[zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly]
    def concurrentBuildLimit: Optional[WrapperInt]
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, ProjectDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSource
        : ZIO[Any, Nothing, zio.aws.codebuild.model.ProjectSource.ReadOnly] =
      ZIO.succeed(source)
    def getSecondarySources: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSource.ReadOnly
    ]] = AwsError.unwrapOptionField("secondarySources", secondarySources)
    def getSourceVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getSecondarySourceVersions: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondarySourceVersions",
      secondarySourceVersions
    )
    def getArtifacts
        : ZIO[Any, Nothing, zio.aws.codebuild.model.ProjectArtifacts.ReadOnly] =
      ZIO.succeed(artifacts)
    def getSecondaryArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectArtifacts.ReadOnly
    ]] = AwsError.unwrapOptionField("secondaryArtifacts", secondaryArtifacts)
    def getCache
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      AwsError.unwrapOptionField("cache", cache)
    def getEnvironment: ZIO[
      Any,
      Nothing,
      zio.aws.codebuild.model.ProjectEnvironment.ReadOnly
    ] = ZIO.succeed(environment)
    def getServiceRole: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(serviceRole)
    def getTimeoutInMinutes: ZIO[Any, AwsError, TimeOut] =
      AwsError.unwrapOptionField("timeoutInMinutes", timeoutInMinutes)
    def getQueuedTimeoutInMinutes: ZIO[Any, AwsError, TimeOut] = AwsError
      .unwrapOptionField("queuedTimeoutInMinutes", queuedTimeoutInMinutes)
    def getEncryptionKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codebuild.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.codebuild.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getBadgeEnabled: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("badgeEnabled", badgeEnabled)
    def getLogsConfig
        : ZIO[Any, AwsError, zio.aws.codebuild.model.LogsConfig.ReadOnly] =
      AwsError.unwrapOptionField("logsConfig", logsConfig)
    def getFileSystemLocations: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemLocations", fileSystemLocations)
    def getBuildBatchConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly
    ] = AwsError.unwrapOptionField("buildBatchConfig", buildBatchConfig)
    def getConcurrentBuildLimit: ZIO[Any, AwsError, WrapperInt] =
      AwsError.unwrapOptionField("concurrentBuildLimit", concurrentBuildLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.CreateProjectRequest
  ) extends zio.aws.codebuild.model.CreateProjectRequest.ReadOnly {
    override val name: ProjectName =
      zio.aws.codebuild.model.primitives.ProjectName(impl.name())
    override val description: Optional[ProjectDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.codebuild.model.primitives.ProjectDescription(value)
        )
    override val source: zio.aws.codebuild.model.ProjectSource.ReadOnly =
      zio.aws.codebuild.model.ProjectSource.wrap(impl.source())
    override val secondarySources
        : Optional[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondarySources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ProjectSource.wrap(item)
          }.toList
        )
    override val sourceVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceVersion())
      .map(value => value: String)
    override val secondarySourceVersions: Optional[
      List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secondarySourceVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectSourceVersion.wrap(item)
        }.toList
      )
    override val artifacts: zio.aws.codebuild.model.ProjectArtifacts.ReadOnly =
      zio.aws.codebuild.model.ProjectArtifacts.wrap(impl.artifacts())
    override val secondaryArtifacts
        : Optional[List[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ProjectArtifacts.wrap(item)
          }.toList
        )
    override val cache
        : Optional[zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cache())
        .map(value => zio.aws.codebuild.model.ProjectCache.wrap(value))
    override val environment
        : zio.aws.codebuild.model.ProjectEnvironment.ReadOnly =
      zio.aws.codebuild.model.ProjectEnvironment.wrap(impl.environment())
    override val serviceRole: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.serviceRole())
    override val timeoutInMinutes: Optional[TimeOut] = zio.aws.core.internal
      .optionalFromNullable(impl.timeoutInMinutes())
      .map(value => zio.aws.codebuild.model.primitives.TimeOut(value))
    override val queuedTimeoutInMinutes: Optional[TimeOut] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queuedTimeoutInMinutes())
        .map(value => zio.aws.codebuild.model.primitives.TimeOut(value))
    override val encryptionKey: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKey())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val tags: Optional[List[zio.aws.codebuild.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.Tag.wrap(item)
          }.toList
        )
    override val vpcConfig
        : Optional[zio.aws.codebuild.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.codebuild.model.VpcConfig.wrap(value))
    override val badgeEnabled: Optional[WrapperBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.badgeEnabled())
      .map(value => value: WrapperBoolean)
    override val logsConfig
        : Optional[zio.aws.codebuild.model.LogsConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logsConfig())
        .map(value => zio.aws.codebuild.model.LogsConfig.wrap(value))
    override val fileSystemLocations: Optional[
      List[zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemLocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectFileSystemLocation.wrap(item)
        }.toList
      )
    override val buildBatchConfig
        : Optional[zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildBatchConfig())
        .map(value =>
          zio.aws.codebuild.model.ProjectBuildBatchConfig.wrap(value)
        )
    override val concurrentBuildLimit: Optional[WrapperInt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.concurrentBuildLimit())
        .map(value => value: WrapperInt)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.CreateProjectRequest
  ): zio.aws.codebuild.model.CreateProjectRequest.ReadOnly = new Wrapper(impl)
}
