package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateProjectResponse(
    project: Option[zio.aws.codebuild.model.Project] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.UpdateProjectResponse = {
    import UpdateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.UpdateProjectResponse
      .builder()
      .optionallyWith(project.map(value => value.buildAwsValue()))(_.project)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.UpdateProjectResponse.ReadOnly =
    zio.aws.codebuild.model.UpdateProjectResponse.wrap(buildAwsValue())
}
object UpdateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.UpdateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.UpdateProjectResponse =
      zio.aws.codebuild.model
        .UpdateProjectResponse(project.map(value => value.asEditable))
    def project: Option[zio.aws.codebuild.model.Project.ReadOnly]
    def getProject
        : ZIO[Any, AwsError, zio.aws.codebuild.model.Project.ReadOnly] =
      AwsError.unwrapOptionField("project", project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateProjectResponse
  ) extends zio.aws.codebuild.model.UpdateProjectResponse.ReadOnly {
    override val project: Option[zio.aws.codebuild.model.Project.ReadOnly] =
      scala
        .Option(impl.project())
        .map(value => zio.aws.codebuild.model.Project.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.UpdateProjectResponse
  ): zio.aws.codebuild.model.UpdateProjectResponse.ReadOnly = new Wrapper(impl)
}
