package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait SharedResourceSortByType {
  def unwrap
      : software.amazon.awssdk.services.codebuild.model.SharedResourceSortByType
}
object SharedResourceSortByType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.SharedResourceSortByType
  ): zio.aws.codebuild.model.SharedResourceSortByType = value match {
    case software.amazon.awssdk.services.codebuild.model.SharedResourceSortByType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.SharedResourceSortByType.ARN =>
      val r = ARN
      r
    case software.amazon.awssdk.services.codebuild.model.SharedResourceSortByType.MODIFIED_TIME =>
      val r = MODIFIED_TIME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.SharedResourceSortByType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SharedResourceSortByType =
      software.amazon.awssdk.services.codebuild.model.SharedResourceSortByType.UNKNOWN_TO_SDK_VERSION
  }
  case object ARN extends zio.aws.codebuild.model.SharedResourceSortByType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SharedResourceSortByType =
      software.amazon.awssdk.services.codebuild.model.SharedResourceSortByType.ARN
  }
  case object MODIFIED_TIME
      extends zio.aws.codebuild.model.SharedResourceSortByType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.SharedResourceSortByType =
      software.amazon.awssdk.services.codebuild.model.SharedResourceSortByType.MODIFIED_TIME
  }
}
