package zio.aws.codebuild.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.PageSize
import scala.jdk.CollectionConverters._
final case class ListSharedReportGroupsRequest(
    sortOrder: Option[zio.aws.codebuild.model.SortOrderType] = None,
    sortBy: Option[zio.aws.codebuild.model.SharedResourceSortByType] = None,
    nextToken: Option[String] = None,
    maxResults: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsRequest = {
    import ListSharedReportGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsRequest
      .builder()
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.ListSharedReportGroupsRequest.ReadOnly =
    zio.aws.codebuild.model.ListSharedReportGroupsRequest.wrap(buildAwsValue())
}
object ListSharedReportGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListSharedReportGroupsRequest =
      zio.aws.codebuild.model.ListSharedReportGroupsRequest(
        sortOrder.map(value => value),
        sortBy.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def sortOrder: Option[zio.aws.codebuild.model.SortOrderType]
    def sortBy: Option[zio.aws.codebuild.model.SharedResourceSortByType]
    def nextToken: Option[String]
    def maxResults: Option[PageSize]
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SharedResourceSortByType] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsRequest
  ) extends zio.aws.codebuild.model.ListSharedReportGroupsRequest.ReadOnly {
    override val sortOrder: Option[zio.aws.codebuild.model.SortOrderType] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.codebuild.model.SortOrderType.wrap(value))
    override val sortBy
        : Option[zio.aws.codebuild.model.SharedResourceSortByType] = scala
      .Option(impl.sortBy())
      .map(value =>
        zio.aws.codebuild.model.SharedResourceSortByType.wrap(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codebuild.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsRequest
  ): zio.aws.codebuild.model.ListSharedReportGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
