package zio.aws.codebuild.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.PageSize
import scala.jdk.CollectionConverters._
final case class ListReportsRequest(
    sortOrder: Option[zio.aws.codebuild.model.SortOrderType] = None,
    nextToken: Option[String] = None,
    maxResults: Option[PageSize] = None,
    filter: Option[zio.aws.codebuild.model.ReportFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListReportsRequest = {
    import ListReportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListReportsRequest
      .builder()
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ListReportsRequest.ReadOnly =
    zio.aws.codebuild.model.ListReportsRequest.wrap(buildAwsValue())
}
object ListReportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListReportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListReportsRequest =
      zio.aws.codebuild.model.ListReportsRequest(
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filter.map(value => value.asEditable)
      )
    def sortOrder: Option[zio.aws.codebuild.model.SortOrderType]
    def nextToken: Option[String]
    def maxResults: Option[PageSize]
    def filter: Option[zio.aws.codebuild.model.ReportFilter.ReadOnly]
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ReportFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListReportsRequest
  ) extends zio.aws.codebuild.model.ListReportsRequest.ReadOnly {
    override val sortOrder: Option[zio.aws.codebuild.model.SortOrderType] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.codebuild.model.SortOrderType.wrap(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codebuild.model.primitives.PageSize(value))
    override val filter: Option[zio.aws.codebuild.model.ReportFilter.ReadOnly] =
      scala
        .Option(impl.filter())
        .map(value => zio.aws.codebuild.model.ReportFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListReportsRequest
  ): zio.aws.codebuild.model.ListReportsRequest.ReadOnly = new Wrapper(impl)
}
