package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class BatchGetProjectsResponse(
    projects: Option[Iterable[zio.aws.codebuild.model.Project]] = None,
    projectsNotFound: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse = {
    import BatchGetProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse
      .builder()
      .optionallyWith(
        projects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projects)
      .optionallyWith(
        projectsNotFound.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.projectsNotFound)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BatchGetProjectsResponse.ReadOnly =
    zio.aws.codebuild.model.BatchGetProjectsResponse.wrap(buildAwsValue())
}
object BatchGetProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BatchGetProjectsResponse =
      zio.aws.codebuild.model.BatchGetProjectsResponse(
        projects.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        projectsNotFound.map(value => value)
      )
    def projects: Option[List[zio.aws.codebuild.model.Project.ReadOnly]]
    def projectsNotFound: Option[List[NonEmptyString]]
    def getProjects
        : ZIO[Any, AwsError, List[zio.aws.codebuild.model.Project.ReadOnly]] =
      AwsError.unwrapOptionField("projects", projects)
    def getProjectsNotFound: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("projectsNotFound", projectsNotFound)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse
  ) extends zio.aws.codebuild.model.BatchGetProjectsResponse.ReadOnly {
    override val projects
        : Option[List[zio.aws.codebuild.model.Project.ReadOnly]] = scala
      .Option(impl.projects())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.Project.wrap(item)
        }.toList
      )
    override val projectsNotFound: Option[List[NonEmptyString]] = scala
      .Option(impl.projectsNotFound())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetProjectsResponse
  ): zio.aws.codebuild.model.BatchGetProjectsResponse.ReadOnly = new Wrapper(
    impl
  )
}
