package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class ListSharedReportGroupsResponse(
    nextToken: Option[String] = None,
    reportGroups: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsResponse = {
    import ListSharedReportGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        reportGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.reportGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.ListSharedReportGroupsResponse.ReadOnly =
    zio.aws.codebuild.model.ListSharedReportGroupsResponse.wrap(buildAwsValue())
}
object ListSharedReportGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListSharedReportGroupsResponse =
      zio.aws.codebuild.model.ListSharedReportGroupsResponse(
        nextToken.map(value => value),
        reportGroups.map(value => value)
      )
    def nextToken: Option[String]
    def reportGroups: Option[List[NonEmptyString]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReportGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("reportGroups", reportGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsResponse
  ) extends zio.aws.codebuild.model.ListSharedReportGroupsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val reportGroups: Option[List[NonEmptyString]] = scala
      .Option(impl.reportGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsResponse
  ): zio.aws.codebuild.model.ListSharedReportGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
