package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.WrapperBoolean
import scala.jdk.CollectionConverters._
final case class S3LogsConfig(
    status: zio.aws.codebuild.model.LogsConfigStatusType,
    location: Option[String] = None,
    encryptionDisabled: Option[WrapperBoolean] = None,
    bucketOwnerAccess: Option[zio.aws.codebuild.model.BucketOwnerAccess] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.S3LogsConfig = {
    import S3LogsConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.S3LogsConfig
      .builder()
      .status(status.unwrap)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(
        encryptionDisabled.map(value =>
          WrapperBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.encryptionDisabled)
      .optionallyWith(bucketOwnerAccess.map(value => value.unwrap))(
        _.bucketOwnerAccess
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.S3LogsConfig.ReadOnly =
    zio.aws.codebuild.model.S3LogsConfig.wrap(buildAwsValue())
}
object S3LogsConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.S3LogsConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.S3LogsConfig =
      zio.aws.codebuild.model.S3LogsConfig(
        status,
        location.map(value => value),
        encryptionDisabled.map(value => value),
        bucketOwnerAccess.map(value => value)
      )
    def status: zio.aws.codebuild.model.LogsConfigStatusType
    def location: Option[String]
    def encryptionDisabled: Option[WrapperBoolean]
    def bucketOwnerAccess: Option[zio.aws.codebuild.model.BucketOwnerAccess]
    def getStatus
        : ZIO[Any, Nothing, zio.aws.codebuild.model.LogsConfigStatusType] =
      ZIO.succeed(status)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getEncryptionDisabled: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("encryptionDisabled", encryptionDisabled)
    def getBucketOwnerAccess
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BucketOwnerAccess] =
      AwsError.unwrapOptionField("bucketOwnerAccess", bucketOwnerAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.S3LogsConfig
  ) extends zio.aws.codebuild.model.S3LogsConfig.ReadOnly {
    override val status: zio.aws.codebuild.model.LogsConfigStatusType =
      zio.aws.codebuild.model.LogsConfigStatusType.wrap(impl.status())
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
    override val encryptionDisabled: Option[WrapperBoolean] = scala
      .Option(impl.encryptionDisabled())
      .map(value => zio.aws.codebuild.model.primitives.WrapperBoolean(value))
    override val bucketOwnerAccess
        : Option[zio.aws.codebuild.model.BucketOwnerAccess] = scala
      .Option(impl.bucketOwnerAccess())
      .map(value => zio.aws.codebuild.model.BucketOwnerAccess.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.S3LogsConfig
  ): zio.aws.codebuild.model.S3LogsConfig.ReadOnly = new Wrapper(impl)
}
