package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class BatchGetReportGroupsResponse(
    reportGroups: Option[Iterable[zio.aws.codebuild.model.ReportGroup]] = None,
    reportGroupsNotFound: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsResponse = {
    import BatchGetReportGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsResponse
      .builder()
      .optionallyWith(
        reportGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reportGroups)
      .optionallyWith(
        reportGroupsNotFound.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.reportGroupsNotFound)
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.BatchGetReportGroupsResponse.ReadOnly =
    zio.aws.codebuild.model.BatchGetReportGroupsResponse.wrap(buildAwsValue())
}
object BatchGetReportGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BatchGetReportGroupsResponse =
      zio.aws.codebuild.model.BatchGetReportGroupsResponse(
        reportGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reportGroupsNotFound.map(value => value)
      )
    def reportGroups: Option[List[zio.aws.codebuild.model.ReportGroup.ReadOnly]]
    def reportGroupsNotFound: Option[List[NonEmptyString]]
    def getReportGroups: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ReportGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("reportGroups", reportGroups)
    def getReportGroupsNotFound: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("reportGroupsNotFound", reportGroupsNotFound)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsResponse
  ) extends zio.aws.codebuild.model.BatchGetReportGroupsResponse.ReadOnly {
    override val reportGroups
        : Option[List[zio.aws.codebuild.model.ReportGroup.ReadOnly]] = scala
      .Option(impl.reportGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ReportGroup.wrap(item)
        }.toList
      )
    override val reportGroupsNotFound: Option[List[NonEmptyString]] = scala
      .Option(impl.reportGroupsNotFound())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsResponse
  ): zio.aws.codebuild.model.BatchGetReportGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
