package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait RetryBuildBatchType {
  def unwrap
      : software.amazon.awssdk.services.codebuild.model.RetryBuildBatchType
}
object RetryBuildBatchType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.RetryBuildBatchType
  ): zio.aws.codebuild.model.RetryBuildBatchType = value match {
    case software.amazon.awssdk.services.codebuild.model.RetryBuildBatchType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.RetryBuildBatchType.RETRY_ALL_BUILDS =>
      val r = RETRY_ALL_BUILDS
      r
    case software.amazon.awssdk.services.codebuild.model.RetryBuildBatchType.RETRY_FAILED_BUILDS =>
      val r = RETRY_FAILED_BUILDS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.RetryBuildBatchType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.RetryBuildBatchType =
      software.amazon.awssdk.services.codebuild.model.RetryBuildBatchType.UNKNOWN_TO_SDK_VERSION
  }
  case object RETRY_ALL_BUILDS
      extends zio.aws.codebuild.model.RetryBuildBatchType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.RetryBuildBatchType =
      software.amazon.awssdk.services.codebuild.model.RetryBuildBatchType.RETRY_ALL_BUILDS
  }
  case object RETRY_FAILED_BUILDS
      extends zio.aws.codebuild.model.RetryBuildBatchType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.RetryBuildBatchType =
      software.amazon.awssdk.services.codebuild.model.RetryBuildBatchType.RETRY_FAILED_BUILDS
  }
}
