package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProjectCache(
    `type`: zio.aws.codebuild.model.CacheType,
    location: Option[String] = None,
    modes: Option[Iterable[zio.aws.codebuild.model.CacheMode]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ProjectCache = {
    import ProjectCache.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ProjectCache
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(
        modes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.modesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ProjectCache.ReadOnly =
    zio.aws.codebuild.model.ProjectCache.wrap(buildAwsValue())
}
object ProjectCache {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ProjectCache
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ProjectCache =
      zio.aws.codebuild.model.ProjectCache(
        `type`,
        location.map(value => value),
        modes.map(value => value)
      )
    def `type`: zio.aws.codebuild.model.CacheType
    def location: Option[String]
    def modes: Option[List[zio.aws.codebuild.model.CacheMode]]
    def getType: ZIO[Any, Nothing, zio.aws.codebuild.model.CacheType] =
      ZIO.succeed(`type`)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getModes: ZIO[Any, AwsError, List[zio.aws.codebuild.model.CacheMode]] =
      AwsError.unwrapOptionField("modes", modes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectCache
  ) extends zio.aws.codebuild.model.ProjectCache.ReadOnly {
    override val `type`: zio.aws.codebuild.model.CacheType =
      zio.aws.codebuild.model.CacheType.wrap(impl.`type`())
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
    override val modes: Option[List[zio.aws.codebuild.model.CacheMode]] = scala
      .Option(impl.modes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.CacheMode.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectCache
  ): zio.aws.codebuild.model.ProjectCache.ReadOnly = new Wrapper(impl)
}
