package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class PutResourcePolicyRequest(
    policy: NonEmptyString,
    resourceArn: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.PutResourcePolicyRequest = {
    import PutResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.PutResourcePolicyRequest
      .builder()
      .policy(NonEmptyString.unwrap(policy): java.lang.String)
      .resourceArn(NonEmptyString.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.PutResourcePolicyRequest.ReadOnly =
    zio.aws.codebuild.model.PutResourcePolicyRequest.wrap(buildAwsValue())
}
object PutResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.PutResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.PutResourcePolicyRequest =
      zio.aws.codebuild.model.PutResourcePolicyRequest(policy, resourceArn)
    def policy: NonEmptyString
    def resourceArn: NonEmptyString
    def getPolicy: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(policy)
    def getResourceArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.PutResourcePolicyRequest
  ) extends zio.aws.codebuild.model.PutResourcePolicyRequest.ReadOnly {
    override val policy: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.policy())
    override val resourceArn: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.PutResourcePolicyRequest
  ): zio.aws.codebuild.model.PutResourcePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
