package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait ArtifactNamespace {
  def unwrap: software.amazon.awssdk.services.codebuild.model.ArtifactNamespace
}
object ArtifactNamespace {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.ArtifactNamespace
  ): zio.aws.codebuild.model.ArtifactNamespace = value match {
    case software.amazon.awssdk.services.codebuild.model.ArtifactNamespace.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.ArtifactNamespace.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.codebuild.model.ArtifactNamespace.BUILD_ID =>
      val r = BUILD_ID
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.ArtifactNamespace {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ArtifactNamespace =
      software.amazon.awssdk.services.codebuild.model.ArtifactNamespace.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.codebuild.model.ArtifactNamespace {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ArtifactNamespace =
      software.amazon.awssdk.services.codebuild.model.ArtifactNamespace.NONE
  }
  case object BUILD_ID extends zio.aws.codebuild.model.ArtifactNamespace {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ArtifactNamespace =
      software.amazon.awssdk.services.codebuild.model.ArtifactNamespace.BUILD_ID
  }
}
