package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class DeleteProjectRequest(name: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.DeleteProjectRequest = {
    import DeleteProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.DeleteProjectRequest
      .builder()
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.DeleteProjectRequest.ReadOnly =
    zio.aws.codebuild.model.DeleteProjectRequest.wrap(buildAwsValue())
}
object DeleteProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.DeleteProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.DeleteProjectRequest =
      zio.aws.codebuild.model.DeleteProjectRequest(name)
    def name: NonEmptyString
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteProjectRequest
  ) extends zio.aws.codebuild.model.DeleteProjectRequest.ReadOnly {
    override val name: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteProjectRequest
  ): zio.aws.codebuild.model.DeleteProjectRequest.ReadOnly = new Wrapper(impl)
}
