package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class BuildNotDeleted(
    id: Optional[NonEmptyString] = Optional.Absent,
    statusCode: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BuildNotDeleted = {
    import BuildNotDeleted.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BuildNotDeleted
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(statusCode.map(value => value: java.lang.String))(
        _.statusCode
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BuildNotDeleted.ReadOnly =
    zio.aws.codebuild.model.BuildNotDeleted.wrap(buildAwsValue())
}
object BuildNotDeleted {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BuildNotDeleted
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BuildNotDeleted =
      zio.aws.codebuild.model
        .BuildNotDeleted(id.map(value => value), statusCode.map(value => value))
    def id: Optional[NonEmptyString]
    def statusCode: Optional[String]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getStatusCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusCode", statusCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BuildNotDeleted
  ) extends zio.aws.codebuild.model.BuildNotDeleted.ReadOnly {
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val statusCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusCode())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BuildNotDeleted
  ): zio.aws.codebuild.model.BuildNotDeleted.ReadOnly = new Wrapper(impl)
}
