package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{
  TimeOut,
  WrapperBoolean,
  GitCloneDepth,
  NonEmptyString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StartBuildRequest(
    projectName: NonEmptyString,
    secondarySourcesOverride: Optional[
      Iterable[zio.aws.codebuild.model.ProjectSource]
    ] = Optional.Absent,
    secondarySourcesVersionOverride: Optional[
      Iterable[zio.aws.codebuild.model.ProjectSourceVersion]
    ] = Optional.Absent,
    sourceVersion: Optional[String] = Optional.Absent,
    artifactsOverride: Optional[zio.aws.codebuild.model.ProjectArtifacts] =
      Optional.Absent,
    secondaryArtifactsOverride: Optional[
      Iterable[zio.aws.codebuild.model.ProjectArtifacts]
    ] = Optional.Absent,
    environmentVariablesOverride: Optional[
      Iterable[zio.aws.codebuild.model.EnvironmentVariable]
    ] = Optional.Absent,
    sourceTypeOverride: Optional[zio.aws.codebuild.model.SourceType] =
      Optional.Absent,
    sourceLocationOverride: Optional[String] = Optional.Absent,
    sourceAuthOverride: Optional[zio.aws.codebuild.model.SourceAuth] =
      Optional.Absent,
    gitCloneDepthOverride: Optional[GitCloneDepth] = Optional.Absent,
    gitSubmodulesConfigOverride: Optional[
      zio.aws.codebuild.model.GitSubmodulesConfig
    ] = Optional.Absent,
    buildspecOverride: Optional[String] = Optional.Absent,
    insecureSslOverride: Optional[WrapperBoolean] = Optional.Absent,
    reportBuildStatusOverride: Optional[WrapperBoolean] = Optional.Absent,
    buildStatusConfigOverride: Optional[
      zio.aws.codebuild.model.BuildStatusConfig
    ] = Optional.Absent,
    environmentTypeOverride: Optional[zio.aws.codebuild.model.EnvironmentType] =
      Optional.Absent,
    imageOverride: Optional[NonEmptyString] = Optional.Absent,
    computeTypeOverride: Optional[zio.aws.codebuild.model.ComputeType] =
      Optional.Absent,
    certificateOverride: Optional[String] = Optional.Absent,
    cacheOverride: Optional[zio.aws.codebuild.model.ProjectCache] =
      Optional.Absent,
    serviceRoleOverride: Optional[NonEmptyString] = Optional.Absent,
    privilegedModeOverride: Optional[WrapperBoolean] = Optional.Absent,
    timeoutInMinutesOverride: Optional[TimeOut] = Optional.Absent,
    queuedTimeoutInMinutesOverride: Optional[TimeOut] = Optional.Absent,
    encryptionKeyOverride: Optional[NonEmptyString] = Optional.Absent,
    idempotencyToken: Optional[String] = Optional.Absent,
    logsConfigOverride: Optional[zio.aws.codebuild.model.LogsConfig] =
      Optional.Absent,
    registryCredentialOverride: Optional[
      zio.aws.codebuild.model.RegistryCredential
    ] = Optional.Absent,
    imagePullCredentialsTypeOverride: Optional[
      zio.aws.codebuild.model.ImagePullCredentialsType
    ] = Optional.Absent,
    debugSessionEnabled: Optional[WrapperBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.StartBuildRequest = {
    import StartBuildRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.StartBuildRequest
      .builder()
      .projectName(NonEmptyString.unwrap(projectName): java.lang.String)
      .optionallyWith(
        secondarySourcesOverride.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySourcesOverride)
      .optionallyWith(
        secondarySourcesVersionOverride.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySourcesVersionOverride)
      .optionallyWith(sourceVersion.map(value => value: java.lang.String))(
        _.sourceVersion
      )
      .optionallyWith(artifactsOverride.map(value => value.buildAwsValue()))(
        _.artifactsOverride
      )
      .optionallyWith(
        secondaryArtifactsOverride.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondaryArtifactsOverride)
      .optionallyWith(
        environmentVariablesOverride.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentVariablesOverride)
      .optionallyWith(sourceTypeOverride.map(value => value.unwrap))(
        _.sourceTypeOverride
      )
      .optionallyWith(
        sourceLocationOverride.map(value => value: java.lang.String)
      )(_.sourceLocationOverride)
      .optionallyWith(sourceAuthOverride.map(value => value.buildAwsValue()))(
        _.sourceAuthOverride
      )
      .optionallyWith(
        gitCloneDepthOverride.map(value => GitCloneDepth.unwrap(value): Integer)
      )(_.gitCloneDepthOverride)
      .optionallyWith(
        gitSubmodulesConfigOverride.map(value => value.buildAwsValue())
      )(_.gitSubmodulesConfigOverride)
      .optionallyWith(buildspecOverride.map(value => value: java.lang.String))(
        _.buildspecOverride
      )
      .optionallyWith(
        insecureSslOverride.map(value => value: java.lang.Boolean)
      )(_.insecureSslOverride)
      .optionallyWith(
        reportBuildStatusOverride.map(value => value: java.lang.Boolean)
      )(_.reportBuildStatusOverride)
      .optionallyWith(
        buildStatusConfigOverride.map(value => value.buildAwsValue())
      )(_.buildStatusConfigOverride)
      .optionallyWith(environmentTypeOverride.map(value => value.unwrap))(
        _.environmentTypeOverride
      )
      .optionallyWith(
        imageOverride.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.imageOverride)
      .optionallyWith(computeTypeOverride.map(value => value.unwrap))(
        _.computeTypeOverride
      )
      .optionallyWith(
        certificateOverride.map(value => value: java.lang.String)
      )(_.certificateOverride)
      .optionallyWith(cacheOverride.map(value => value.buildAwsValue()))(
        _.cacheOverride
      )
      .optionallyWith(
        serviceRoleOverride.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.serviceRoleOverride)
      .optionallyWith(
        privilegedModeOverride.map(value => value: java.lang.Boolean)
      )(_.privilegedModeOverride)
      .optionallyWith(
        timeoutInMinutesOverride.map(value => TimeOut.unwrap(value): Integer)
      )(_.timeoutInMinutesOverride)
      .optionallyWith(
        queuedTimeoutInMinutesOverride.map(value =>
          TimeOut.unwrap(value): Integer
        )
      )(_.queuedTimeoutInMinutesOverride)
      .optionallyWith(
        encryptionKeyOverride.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKeyOverride)
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .optionallyWith(logsConfigOverride.map(value => value.buildAwsValue()))(
        _.logsConfigOverride
      )
      .optionallyWith(
        registryCredentialOverride.map(value => value.buildAwsValue())
      )(_.registryCredentialOverride)
      .optionallyWith(
        imagePullCredentialsTypeOverride.map(value => value.unwrap)
      )(_.imagePullCredentialsTypeOverride)
      .optionallyWith(
        debugSessionEnabled.map(value => value: java.lang.Boolean)
      )(_.debugSessionEnabled)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.StartBuildRequest.ReadOnly =
    zio.aws.codebuild.model.StartBuildRequest.wrap(buildAwsValue())
}
object StartBuildRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.StartBuildRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.StartBuildRequest =
      zio.aws.codebuild.model.StartBuildRequest(
        projectName,
        secondarySourcesOverride.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secondarySourcesVersionOverride.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceVersion.map(value => value),
        artifactsOverride.map(value => value.asEditable),
        secondaryArtifactsOverride.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environmentVariablesOverride.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceTypeOverride.map(value => value),
        sourceLocationOverride.map(value => value),
        sourceAuthOverride.map(value => value.asEditable),
        gitCloneDepthOverride.map(value => value),
        gitSubmodulesConfigOverride.map(value => value.asEditable),
        buildspecOverride.map(value => value),
        insecureSslOverride.map(value => value),
        reportBuildStatusOverride.map(value => value),
        buildStatusConfigOverride.map(value => value.asEditable),
        environmentTypeOverride.map(value => value),
        imageOverride.map(value => value),
        computeTypeOverride.map(value => value),
        certificateOverride.map(value => value),
        cacheOverride.map(value => value.asEditable),
        serviceRoleOverride.map(value => value),
        privilegedModeOverride.map(value => value),
        timeoutInMinutesOverride.map(value => value),
        queuedTimeoutInMinutesOverride.map(value => value),
        encryptionKeyOverride.map(value => value),
        idempotencyToken.map(value => value),
        logsConfigOverride.map(value => value.asEditable),
        registryCredentialOverride.map(value => value.asEditable),
        imagePullCredentialsTypeOverride.map(value => value),
        debugSessionEnabled.map(value => value)
      )
    def projectName: NonEmptyString
    def secondarySourcesOverride
        : Optional[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]]
    def secondarySourcesVersionOverride
        : Optional[List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]]
    def sourceVersion: Optional[String]
    def artifactsOverride
        : Optional[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly]
    def secondaryArtifactsOverride
        : Optional[List[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly]]
    def environmentVariablesOverride
        : Optional[List[zio.aws.codebuild.model.EnvironmentVariable.ReadOnly]]
    def sourceTypeOverride: Optional[zio.aws.codebuild.model.SourceType]
    def sourceLocationOverride: Optional[String]
    def sourceAuthOverride
        : Optional[zio.aws.codebuild.model.SourceAuth.ReadOnly]
    def gitCloneDepthOverride: Optional[GitCloneDepth]
    def gitSubmodulesConfigOverride
        : Optional[zio.aws.codebuild.model.GitSubmodulesConfig.ReadOnly]
    def buildspecOverride: Optional[String]
    def insecureSslOverride: Optional[WrapperBoolean]
    def reportBuildStatusOverride: Optional[WrapperBoolean]
    def buildStatusConfigOverride
        : Optional[zio.aws.codebuild.model.BuildStatusConfig.ReadOnly]
    def environmentTypeOverride
        : Optional[zio.aws.codebuild.model.EnvironmentType]
    def imageOverride: Optional[NonEmptyString]
    def computeTypeOverride: Optional[zio.aws.codebuild.model.ComputeType]
    def certificateOverride: Optional[String]
    def cacheOverride: Optional[zio.aws.codebuild.model.ProjectCache.ReadOnly]
    def serviceRoleOverride: Optional[NonEmptyString]
    def privilegedModeOverride: Optional[WrapperBoolean]
    def timeoutInMinutesOverride: Optional[TimeOut]
    def queuedTimeoutInMinutesOverride: Optional[TimeOut]
    def encryptionKeyOverride: Optional[NonEmptyString]
    def idempotencyToken: Optional[String]
    def logsConfigOverride
        : Optional[zio.aws.codebuild.model.LogsConfig.ReadOnly]
    def registryCredentialOverride
        : Optional[zio.aws.codebuild.model.RegistryCredential.ReadOnly]
    def imagePullCredentialsTypeOverride
        : Optional[zio.aws.codebuild.model.ImagePullCredentialsType]
    def debugSessionEnabled: Optional[WrapperBoolean]
    def getProjectName: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(projectName)
    def getSecondarySourcesOverride: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSource.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondarySourcesOverride",
      secondarySourcesOverride
    )
    def getSecondarySourcesVersionOverride: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondarySourcesVersionOverride",
      secondarySourcesVersionOverride
    )
    def getSourceVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getArtifactsOverride: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectArtifacts.ReadOnly
    ] = AwsError.unwrapOptionField("artifactsOverride", artifactsOverride)
    def getSecondaryArtifactsOverride: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectArtifacts.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondaryArtifactsOverride",
      secondaryArtifactsOverride
    )
    def getEnvironmentVariablesOverride: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.EnvironmentVariable.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "environmentVariablesOverride",
      environmentVariablesOverride
    )
    def getSourceTypeOverride
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SourceType] =
      AwsError.unwrapOptionField("sourceTypeOverride", sourceTypeOverride)
    def getSourceLocationOverride: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("sourceLocationOverride", sourceLocationOverride)
    def getSourceAuthOverride
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SourceAuth.ReadOnly] =
      AwsError.unwrapOptionField("sourceAuthOverride", sourceAuthOverride)
    def getGitCloneDepthOverride: ZIO[Any, AwsError, GitCloneDepth] =
      AwsError.unwrapOptionField("gitCloneDepthOverride", gitCloneDepthOverride)
    def getGitSubmodulesConfigOverride: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.GitSubmodulesConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "gitSubmodulesConfigOverride",
      gitSubmodulesConfigOverride
    )
    def getBuildspecOverride: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("buildspecOverride", buildspecOverride)
    def getInsecureSslOverride: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("insecureSslOverride", insecureSslOverride)
    def getReportBuildStatusOverride: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField(
        "reportBuildStatusOverride",
        reportBuildStatusOverride
      )
    def getBuildStatusConfigOverride: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.BuildStatusConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "buildStatusConfigOverride",
      buildStatusConfigOverride
    )
    def getEnvironmentTypeOverride
        : ZIO[Any, AwsError, zio.aws.codebuild.model.EnvironmentType] = AwsError
      .unwrapOptionField("environmentTypeOverride", environmentTypeOverride)
    def getImageOverride: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imageOverride", imageOverride)
    def getComputeTypeOverride
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ComputeType] =
      AwsError.unwrapOptionField("computeTypeOverride", computeTypeOverride)
    def getCertificateOverride: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateOverride", certificateOverride)
    def getCacheOverride
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      AwsError.unwrapOptionField("cacheOverride", cacheOverride)
    def getServiceRoleOverride: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceRoleOverride", serviceRoleOverride)
    def getPrivilegedModeOverride: ZIO[Any, AwsError, WrapperBoolean] = AwsError
      .unwrapOptionField("privilegedModeOverride", privilegedModeOverride)
    def getTimeoutInMinutesOverride: ZIO[Any, AwsError, TimeOut] = AwsError
      .unwrapOptionField("timeoutInMinutesOverride", timeoutInMinutesOverride)
    def getQueuedTimeoutInMinutesOverride: ZIO[Any, AwsError, TimeOut] =
      AwsError.unwrapOptionField(
        "queuedTimeoutInMinutesOverride",
        queuedTimeoutInMinutesOverride
      )
    def getEncryptionKeyOverride: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKeyOverride", encryptionKeyOverride)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getLogsConfigOverride
        : ZIO[Any, AwsError, zio.aws.codebuild.model.LogsConfig.ReadOnly] =
      AwsError.unwrapOptionField("logsConfigOverride", logsConfigOverride)
    def getRegistryCredentialOverride: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.RegistryCredential.ReadOnly
    ] = AwsError.unwrapOptionField(
      "registryCredentialOverride",
      registryCredentialOverride
    )
    def getImagePullCredentialsTypeOverride
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ImagePullCredentialsType] =
      AwsError.unwrapOptionField(
        "imagePullCredentialsTypeOverride",
        imagePullCredentialsTypeOverride
      )
    def getDebugSessionEnabled: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("debugSessionEnabled", debugSessionEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.StartBuildRequest
  ) extends zio.aws.codebuild.model.StartBuildRequest.ReadOnly {
    override val projectName: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.projectName())
    override val secondarySourcesOverride
        : Optional[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondarySourcesOverride())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ProjectSource.wrap(item)
          }.toList
        )
    override val secondarySourcesVersionOverride: Optional[
      List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secondarySourcesVersionOverride())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectSourceVersion.wrap(item)
        }.toList
      )
    override val sourceVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceVersion())
      .map(value => value: String)
    override val artifactsOverride
        : Optional[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactsOverride())
        .map(value => zio.aws.codebuild.model.ProjectArtifacts.wrap(value))
    override val secondaryArtifactsOverride
        : Optional[List[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryArtifactsOverride())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ProjectArtifacts.wrap(item)
          }.toList
        )
    override val environmentVariablesOverride
        : Optional[List[zio.aws.codebuild.model.EnvironmentVariable.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentVariablesOverride())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.EnvironmentVariable.wrap(item)
          }.toList
        )
    override val sourceTypeOverride
        : Optional[zio.aws.codebuild.model.SourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceTypeOverride())
      .map(value => zio.aws.codebuild.model.SourceType.wrap(value))
    override val sourceLocationOverride: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceLocationOverride())
        .map(value => value: String)
    override val sourceAuthOverride
        : Optional[zio.aws.codebuild.model.SourceAuth.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceAuthOverride())
        .map(value => zio.aws.codebuild.model.SourceAuth.wrap(value))
    override val gitCloneDepthOverride: Optional[GitCloneDepth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gitCloneDepthOverride())
        .map(value => zio.aws.codebuild.model.primitives.GitCloneDepth(value))
    override val gitSubmodulesConfigOverride
        : Optional[zio.aws.codebuild.model.GitSubmodulesConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gitSubmodulesConfigOverride())
        .map(value => zio.aws.codebuild.model.GitSubmodulesConfig.wrap(value))
    override val buildspecOverride: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.buildspecOverride())
      .map(value => value: String)
    override val insecureSslOverride: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insecureSslOverride())
        .map(value => value: WrapperBoolean)
    override val reportBuildStatusOverride: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportBuildStatusOverride())
        .map(value => value: WrapperBoolean)
    override val buildStatusConfigOverride
        : Optional[zio.aws.codebuild.model.BuildStatusConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildStatusConfigOverride())
        .map(value => zio.aws.codebuild.model.BuildStatusConfig.wrap(value))
    override val environmentTypeOverride
        : Optional[zio.aws.codebuild.model.EnvironmentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentTypeOverride())
        .map(value => zio.aws.codebuild.model.EnvironmentType.wrap(value))
    override val imageOverride: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.imageOverride())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val computeTypeOverride
        : Optional[zio.aws.codebuild.model.ComputeType] = zio.aws.core.internal
      .optionalFromNullable(impl.computeTypeOverride())
      .map(value => zio.aws.codebuild.model.ComputeType.wrap(value))
    override val certificateOverride: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateOverride())
      .map(value => value: String)
    override val cacheOverride
        : Optional[zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cacheOverride())
        .map(value => zio.aws.codebuild.model.ProjectCache.wrap(value))
    override val serviceRoleOverride: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceRoleOverride())
        .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val privilegedModeOverride: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privilegedModeOverride())
        .map(value => value: WrapperBoolean)
    override val timeoutInMinutesOverride: Optional[TimeOut] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutInMinutesOverride())
        .map(value => zio.aws.codebuild.model.primitives.TimeOut(value))
    override val queuedTimeoutInMinutesOverride: Optional[TimeOut] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queuedTimeoutInMinutesOverride())
        .map(value => zio.aws.codebuild.model.primitives.TimeOut(value))
    override val encryptionKeyOverride: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKeyOverride())
        .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val idempotencyToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.idempotencyToken())
      .map(value => value: String)
    override val logsConfigOverride
        : Optional[zio.aws.codebuild.model.LogsConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logsConfigOverride())
        .map(value => zio.aws.codebuild.model.LogsConfig.wrap(value))
    override val registryCredentialOverride
        : Optional[zio.aws.codebuild.model.RegistryCredential.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registryCredentialOverride())
        .map(value => zio.aws.codebuild.model.RegistryCredential.wrap(value))
    override val imagePullCredentialsTypeOverride
        : Optional[zio.aws.codebuild.model.ImagePullCredentialsType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imagePullCredentialsTypeOverride())
        .map(value =>
          zio.aws.codebuild.model.ImagePullCredentialsType.wrap(value)
        )
    override val debugSessionEnabled: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.debugSessionEnabled())
        .map(value => value: WrapperBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.StartBuildRequest
  ): zio.aws.codebuild.model.StartBuildRequest.ReadOnly = new Wrapper(impl)
}
