package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{
  WrapperBoolean,
  Timestamp,
  WrapperLong,
  WrapperInt,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class BuildBatch(
    id: Optional[NonEmptyString] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    currentPhase: Optional[String] = Optional.Absent,
    buildBatchStatus: Optional[zio.aws.codebuild.model.StatusType] =
      Optional.Absent,
    sourceVersion: Optional[NonEmptyString] = Optional.Absent,
    resolvedSourceVersion: Optional[NonEmptyString] = Optional.Absent,
    projectName: Optional[NonEmptyString] = Optional.Absent,
    phases: Optional[Iterable[zio.aws.codebuild.model.BuildBatchPhase]] =
      Optional.Absent,
    source: Optional[zio.aws.codebuild.model.ProjectSource] = Optional.Absent,
    secondarySources: Optional[
      Iterable[zio.aws.codebuild.model.ProjectSource]
    ] = Optional.Absent,
    secondarySourceVersions: Optional[
      Iterable[zio.aws.codebuild.model.ProjectSourceVersion]
    ] = Optional.Absent,
    artifacts: Optional[zio.aws.codebuild.model.BuildArtifacts] =
      Optional.Absent,
    secondaryArtifacts: Optional[
      Iterable[zio.aws.codebuild.model.BuildArtifacts]
    ] = Optional.Absent,
    cache: Optional[zio.aws.codebuild.model.ProjectCache] = Optional.Absent,
    environment: Optional[zio.aws.codebuild.model.ProjectEnvironment] =
      Optional.Absent,
    serviceRole: Optional[NonEmptyString] = Optional.Absent,
    logConfig: Optional[zio.aws.codebuild.model.LogsConfig] = Optional.Absent,
    buildTimeoutInMinutes: Optional[WrapperInt] = Optional.Absent,
    queuedTimeoutInMinutes: Optional[WrapperInt] = Optional.Absent,
    complete: Optional[Boolean] = Optional.Absent,
    initiator: Optional[String] = Optional.Absent,
    vpcConfig: Optional[zio.aws.codebuild.model.VpcConfig] = Optional.Absent,
    encryptionKey: Optional[NonEmptyString] = Optional.Absent,
    buildBatchNumber: Optional[WrapperLong] = Optional.Absent,
    fileSystemLocations: Optional[
      Iterable[zio.aws.codebuild.model.ProjectFileSystemLocation]
    ] = Optional.Absent,
    buildBatchConfig: Optional[
      zio.aws.codebuild.model.ProjectBuildBatchConfig
    ] = Optional.Absent,
    buildGroups: Optional[Iterable[zio.aws.codebuild.model.BuildGroup]] =
      Optional.Absent,
    debugSessionEnabled: Optional[WrapperBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BuildBatch = {
    import BuildBatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BuildBatch
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(currentPhase.map(value => value: java.lang.String))(
        _.currentPhase
      )
      .optionallyWith(buildBatchStatus.map(value => value.unwrap))(
        _.buildBatchStatus
      )
      .optionallyWith(
        sourceVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceVersion)
      .optionallyWith(
        resolvedSourceVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resolvedSourceVersion)
      .optionallyWith(
        projectName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.projectName)
      .optionallyWith(
        phases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phases)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        secondarySources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySources)
      .optionallyWith(
        secondarySourceVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySourceVersions)
      .optionallyWith(artifacts.map(value => value.buildAwsValue()))(
        _.artifacts
      )
      .optionallyWith(
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondaryArtifacts)
      .optionallyWith(cache.map(value => value.buildAwsValue()))(_.cache)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(
        serviceRole.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(logConfig.map(value => value.buildAwsValue()))(
        _.logConfig
      )
      .optionallyWith(buildTimeoutInMinutes.map(value => value: Integer))(
        _.buildTimeoutInMinutes
      )
      .optionallyWith(queuedTimeoutInMinutes.map(value => value: Integer))(
        _.queuedTimeoutInMinutes
      )
      .optionallyWith(complete.map(value => value: java.lang.Boolean))(
        _.complete
      )
      .optionallyWith(initiator.map(value => value: java.lang.String))(
        _.initiator
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        encryptionKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKey)
      .optionallyWith(buildBatchNumber.map(value => value: java.lang.Long))(
        _.buildBatchNumber
      )
      .optionallyWith(
        fileSystemLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemLocations)
      .optionallyWith(buildBatchConfig.map(value => value.buildAwsValue()))(
        _.buildBatchConfig
      )
      .optionallyWith(
        buildGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buildGroups)
      .optionallyWith(
        debugSessionEnabled.map(value => value: java.lang.Boolean)
      )(_.debugSessionEnabled)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BuildBatch.ReadOnly =
    zio.aws.codebuild.model.BuildBatch.wrap(buildAwsValue())
}
object BuildBatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BuildBatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BuildBatch =
      zio.aws.codebuild.model.BuildBatch(
        id.map(value => value),
        arn.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        currentPhase.map(value => value),
        buildBatchStatus.map(value => value),
        sourceVersion.map(value => value),
        resolvedSourceVersion.map(value => value),
        projectName.map(value => value),
        phases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        source.map(value => value.asEditable),
        secondarySources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secondarySourceVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        artifacts.map(value => value.asEditable),
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cache.map(value => value.asEditable),
        environment.map(value => value.asEditable),
        serviceRole.map(value => value),
        logConfig.map(value => value.asEditable),
        buildTimeoutInMinutes.map(value => value),
        queuedTimeoutInMinutes.map(value => value),
        complete.map(value => value),
        initiator.map(value => value),
        vpcConfig.map(value => value.asEditable),
        encryptionKey.map(value => value),
        buildBatchNumber.map(value => value),
        fileSystemLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        buildBatchConfig.map(value => value.asEditable),
        buildGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        debugSessionEnabled.map(value => value)
      )
    def id: Optional[NonEmptyString]
    def arn: Optional[NonEmptyString]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def currentPhase: Optional[String]
    def buildBatchStatus: Optional[zio.aws.codebuild.model.StatusType]
    def sourceVersion: Optional[NonEmptyString]
    def resolvedSourceVersion: Optional[NonEmptyString]
    def projectName: Optional[NonEmptyString]
    def phases: Optional[List[zio.aws.codebuild.model.BuildBatchPhase.ReadOnly]]
    def source: Optional[zio.aws.codebuild.model.ProjectSource.ReadOnly]
    def secondarySources
        : Optional[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]]
    def secondarySourceVersions
        : Optional[List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]]
    def artifacts: Optional[zio.aws.codebuild.model.BuildArtifacts.ReadOnly]
    def secondaryArtifacts
        : Optional[List[zio.aws.codebuild.model.BuildArtifacts.ReadOnly]]
    def cache: Optional[zio.aws.codebuild.model.ProjectCache.ReadOnly]
    def environment
        : Optional[zio.aws.codebuild.model.ProjectEnvironment.ReadOnly]
    def serviceRole: Optional[NonEmptyString]
    def logConfig: Optional[zio.aws.codebuild.model.LogsConfig.ReadOnly]
    def buildTimeoutInMinutes: Optional[WrapperInt]
    def queuedTimeoutInMinutes: Optional[WrapperInt]
    def complete: Optional[Boolean]
    def initiator: Optional[String]
    def vpcConfig: Optional[zio.aws.codebuild.model.VpcConfig.ReadOnly]
    def encryptionKey: Optional[NonEmptyString]
    def buildBatchNumber: Optional[WrapperLong]
    def fileSystemLocations: Optional[
      List[zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly]
    ]
    def buildBatchConfig
        : Optional[zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly]
    def buildGroups: Optional[List[zio.aws.codebuild.model.BuildGroup.ReadOnly]]
    def debugSessionEnabled: Optional[WrapperBoolean]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getCurrentPhase: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentPhase", currentPhase)
    def getBuildBatchStatus
        : ZIO[Any, AwsError, zio.aws.codebuild.model.StatusType] =
      AwsError.unwrapOptionField("buildBatchStatus", buildBatchStatus)
    def getSourceVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getResolvedSourceVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resolvedSourceVersion", resolvedSourceVersion)
    def getProjectName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getPhases: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.BuildBatchPhase.ReadOnly
    ]] = AwsError.unwrapOptionField("phases", phases)
    def getSource
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getSecondarySources: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSource.ReadOnly
    ]] = AwsError.unwrapOptionField("secondarySources", secondarySources)
    def getSecondarySourceVersions: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondarySourceVersions",
      secondarySourceVersions
    )
    def getArtifacts
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BuildArtifacts.ReadOnly] =
      AwsError.unwrapOptionField("artifacts", artifacts)
    def getSecondaryArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.BuildArtifacts.ReadOnly
    ]] = AwsError.unwrapOptionField("secondaryArtifacts", secondaryArtifacts)
    def getCache
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      AwsError.unwrapOptionField("cache", cache)
    def getEnvironment: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectEnvironment.ReadOnly
    ] = AwsError.unwrapOptionField("environment", environment)
    def getServiceRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getLogConfig
        : ZIO[Any, AwsError, zio.aws.codebuild.model.LogsConfig.ReadOnly] =
      AwsError.unwrapOptionField("logConfig", logConfig)
    def getBuildTimeoutInMinutes: ZIO[Any, AwsError, WrapperInt] =
      AwsError.unwrapOptionField("buildTimeoutInMinutes", buildTimeoutInMinutes)
    def getQueuedTimeoutInMinutes: ZIO[Any, AwsError, WrapperInt] = AwsError
      .unwrapOptionField("queuedTimeoutInMinutes", queuedTimeoutInMinutes)
    def getComplete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("complete", complete)
    def getInitiator: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("initiator", initiator)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.codebuild.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getEncryptionKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getBuildBatchNumber: ZIO[Any, AwsError, WrapperLong] =
      AwsError.unwrapOptionField("buildBatchNumber", buildBatchNumber)
    def getFileSystemLocations: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemLocations", fileSystemLocations)
    def getBuildBatchConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly
    ] = AwsError.unwrapOptionField("buildBatchConfig", buildBatchConfig)
    def getBuildGroups: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.BuildGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("buildGroups", buildGroups)
    def getDebugSessionEnabled: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("debugSessionEnabled", debugSessionEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BuildBatch
  ) extends zio.aws.codebuild.model.BuildBatch.ReadOnly {
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val currentPhase: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currentPhase())
      .map(value => value: String)
    override val buildBatchStatus
        : Optional[zio.aws.codebuild.model.StatusType] = zio.aws.core.internal
      .optionalFromNullable(impl.buildBatchStatus())
      .map(value => zio.aws.codebuild.model.StatusType.wrap(value))
    override val sourceVersion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceVersion())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val resolvedSourceVersion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolvedSourceVersion())
        .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val projectName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.projectName())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val phases
        : Optional[List[zio.aws.codebuild.model.BuildBatchPhase.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.BuildBatchPhase.wrap(item)
          }.toList
        )
    override val source
        : Optional[zio.aws.codebuild.model.ProjectSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.codebuild.model.ProjectSource.wrap(value))
    override val secondarySources
        : Optional[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondarySources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ProjectSource.wrap(item)
          }.toList
        )
    override val secondarySourceVersions: Optional[
      List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secondarySourceVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectSourceVersion.wrap(item)
        }.toList
      )
    override val artifacts
        : Optional[zio.aws.codebuild.model.BuildArtifacts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifacts())
        .map(value => zio.aws.codebuild.model.BuildArtifacts.wrap(value))
    override val secondaryArtifacts
        : Optional[List[zio.aws.codebuild.model.BuildArtifacts.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.BuildArtifacts.wrap(item)
          }.toList
        )
    override val cache
        : Optional[zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cache())
        .map(value => zio.aws.codebuild.model.ProjectCache.wrap(value))
    override val environment
        : Optional[zio.aws.codebuild.model.ProjectEnvironment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value => zio.aws.codebuild.model.ProjectEnvironment.wrap(value))
    override val serviceRole: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val logConfig
        : Optional[zio.aws.codebuild.model.LogsConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logConfig())
        .map(value => zio.aws.codebuild.model.LogsConfig.wrap(value))
    override val buildTimeoutInMinutes: Optional[WrapperInt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildTimeoutInMinutes())
        .map(value => value: WrapperInt)
    override val queuedTimeoutInMinutes: Optional[WrapperInt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queuedTimeoutInMinutes())
        .map(value => value: WrapperInt)
    override val complete: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.complete())
      .map(value => value: Boolean)
    override val initiator: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.initiator())
      .map(value => value: String)
    override val vpcConfig
        : Optional[zio.aws.codebuild.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.codebuild.model.VpcConfig.wrap(value))
    override val encryptionKey: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKey())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val buildBatchNumber: Optional[WrapperLong] = zio.aws.core.internal
      .optionalFromNullable(impl.buildBatchNumber())
      .map(value => value: WrapperLong)
    override val fileSystemLocations: Optional[
      List[zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemLocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectFileSystemLocation.wrap(item)
        }.toList
      )
    override val buildBatchConfig
        : Optional[zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildBatchConfig())
        .map(value =>
          zio.aws.codebuild.model.ProjectBuildBatchConfig.wrap(value)
        )
    override val buildGroups
        : Optional[List[zio.aws.codebuild.model.BuildGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.BuildGroup.wrap(item)
          }.toList
        )
    override val debugSessionEnabled: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.debugSessionEnabled())
        .map(value => value: WrapperBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BuildBatch
  ): zio.aws.codebuild.model.BuildBatch.ReadOnly = new Wrapper(impl)
}
