package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.PageSize
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReportsForReportGroupRequest(
    reportGroupArn: String,
    nextToken: Optional[String] = Optional.Absent,
    sortOrder: Optional[zio.aws.codebuild.model.SortOrderType] =
      Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    filter: Optional[zio.aws.codebuild.model.ReportFilter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupRequest = {
    import ListReportsForReportGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupRequest
      .builder()
      .reportGroupArn(reportGroupArn: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.ListReportsForReportGroupRequest.ReadOnly =
    zio.aws.codebuild.model.ListReportsForReportGroupRequest
      .wrap(buildAwsValue())
}
object ListReportsForReportGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListReportsForReportGroupRequest =
      zio.aws.codebuild.model.ListReportsForReportGroupRequest(
        reportGroupArn,
        nextToken.map(value => value),
        sortOrder.map(value => value),
        maxResults.map(value => value),
        filter.map(value => value.asEditable)
      )
    def reportGroupArn: String
    def nextToken: Optional[String]
    def sortOrder: Optional[zio.aws.codebuild.model.SortOrderType]
    def maxResults: Optional[PageSize]
    def filter: Optional[zio.aws.codebuild.model.ReportFilter.ReadOnly]
    def getReportGroupArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(reportGroupArn)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ReportFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupRequest
  ) extends zio.aws.codebuild.model.ListReportsForReportGroupRequest.ReadOnly {
    override val reportGroupArn: String = impl.reportGroupArn(): String
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val sortOrder: Optional[zio.aws.codebuild.model.SortOrderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.codebuild.model.SortOrderType.wrap(value))
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codebuild.model.primitives.PageSize(value))
    override val filter
        : Optional[zio.aws.codebuild.model.ReportFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.codebuild.model.ReportFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListReportsForReportGroupRequest
  ): zio.aws.codebuild.model.ListReportsForReportGroupRequest.ReadOnly =
    new Wrapper(impl)
}
