package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{PageSize, NonEmptyString}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListBuildBatchesForProjectRequest(
    projectName: Optional[NonEmptyString] = Optional.Absent,
    filter: Optional[zio.aws.codebuild.model.BuildBatchFilter] =
      Optional.Absent,
    maxResults: Optional[PageSize] = Optional.Absent,
    sortOrder: Optional[zio.aws.codebuild.model.SortOrderType] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest = {
    import ListBuildBatchesForProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest
      .builder()
      .optionallyWith(
        projectName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.projectName)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.ListBuildBatchesForProjectRequest.ReadOnly =
    zio.aws.codebuild.model.ListBuildBatchesForProjectRequest
      .wrap(buildAwsValue())
}
object ListBuildBatchesForProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListBuildBatchesForProjectRequest =
      zio.aws.codebuild.model.ListBuildBatchesForProjectRequest(
        projectName.map(value => value),
        filter.map(value => value.asEditable),
        maxResults.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value)
      )
    def projectName: Optional[NonEmptyString]
    def filter: Optional[zio.aws.codebuild.model.BuildBatchFilter.ReadOnly]
    def maxResults: Optional[PageSize]
    def sortOrder: Optional[zio.aws.codebuild.model.SortOrderType]
    def nextToken: Optional[String]
    def getProjectName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.BuildBatchFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest
  ) extends zio.aws.codebuild.model.ListBuildBatchesForProjectRequest.ReadOnly {
    override val projectName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.projectName())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val filter
        : Optional[zio.aws.codebuild.model.BuildBatchFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.codebuild.model.BuildBatchFilter.wrap(value))
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.codebuild.model.primitives.PageSize(value))
    override val sortOrder: Optional[zio.aws.codebuild.model.SortOrderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.codebuild.model.SortOrderType.wrap(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectRequest
  ): zio.aws.codebuild.model.ListBuildBatchesForProjectRequest.ReadOnly =
    new Wrapper(impl)
}
