package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class BatchGetProjectsRequest(names: Iterable[NonEmptyString]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BatchGetProjectsRequest = {
    import BatchGetProjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BatchGetProjectsRequest
      .builder()
      .names(names.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BatchGetProjectsRequest.ReadOnly =
    zio.aws.codebuild.model.BatchGetProjectsRequest.wrap(buildAwsValue())
}
object BatchGetProjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BatchGetProjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BatchGetProjectsRequest =
      zio.aws.codebuild.model.BatchGetProjectsRequest(names)
    def names: List[NonEmptyString]
    def getNames: ZIO[Any, Nothing, List[NonEmptyString]] = ZIO.succeed(names)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetProjectsRequest
  ) extends zio.aws.codebuild.model.BatchGetProjectsRequest.ReadOnly {
    override val names: List[NonEmptyString] = impl
      .names()
      .asScala
      .map { item =>
        zio.aws.codebuild.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetProjectsRequest
  ): zio.aws.codebuild.model.BatchGetProjectsRequest.ReadOnly = new Wrapper(
    impl
  )
}
