package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.WrapperBoolean
import scala.jdk.CollectionConverters._
final case class ProjectArtifacts(
    `type`: zio.aws.codebuild.model.ArtifactsType,
    location: Optional[String] = Optional.Absent,
    path: Optional[String] = Optional.Absent,
    namespaceType: Optional[zio.aws.codebuild.model.ArtifactNamespace] =
      Optional.Absent,
    name: Optional[String] = Optional.Absent,
    packaging: Optional[zio.aws.codebuild.model.ArtifactPackaging] =
      Optional.Absent,
    overrideArtifactName: Optional[WrapperBoolean] = Optional.Absent,
    encryptionDisabled: Optional[WrapperBoolean] = Optional.Absent,
    artifactIdentifier: Optional[String] = Optional.Absent,
    bucketOwnerAccess: Optional[zio.aws.codebuild.model.BucketOwnerAccess] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ProjectArtifacts = {
    import ProjectArtifacts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ProjectArtifacts
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(namespaceType.map(value => value.unwrap))(_.namespaceType)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(packaging.map(value => value.unwrap))(_.packaging)
      .optionallyWith(
        overrideArtifactName.map(value => value: java.lang.Boolean)
      )(_.overrideArtifactName)
      .optionallyWith(
        encryptionDisabled.map(value => value: java.lang.Boolean)
      )(_.encryptionDisabled)
      .optionallyWith(artifactIdentifier.map(value => value: java.lang.String))(
        _.artifactIdentifier
      )
      .optionallyWith(bucketOwnerAccess.map(value => value.unwrap))(
        _.bucketOwnerAccess
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ProjectArtifacts.ReadOnly =
    zio.aws.codebuild.model.ProjectArtifacts.wrap(buildAwsValue())
}
object ProjectArtifacts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ProjectArtifacts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ProjectArtifacts =
      zio.aws.codebuild.model.ProjectArtifacts(
        `type`,
        location.map(value => value),
        path.map(value => value),
        namespaceType.map(value => value),
        name.map(value => value),
        packaging.map(value => value),
        overrideArtifactName.map(value => value),
        encryptionDisabled.map(value => value),
        artifactIdentifier.map(value => value),
        bucketOwnerAccess.map(value => value)
      )
    def `type`: zio.aws.codebuild.model.ArtifactsType
    def location: Optional[String]
    def path: Optional[String]
    def namespaceType: Optional[zio.aws.codebuild.model.ArtifactNamespace]
    def name: Optional[String]
    def packaging: Optional[zio.aws.codebuild.model.ArtifactPackaging]
    def overrideArtifactName: Optional[WrapperBoolean]
    def encryptionDisabled: Optional[WrapperBoolean]
    def artifactIdentifier: Optional[String]
    def bucketOwnerAccess: Optional[zio.aws.codebuild.model.BucketOwnerAccess]
    def getType: ZIO[Any, Nothing, zio.aws.codebuild.model.ArtifactsType] =
      ZIO.succeed(`type`)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getNamespaceType
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ArtifactNamespace] =
      AwsError.unwrapOptionField("namespaceType", namespaceType)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getPackaging
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ArtifactPackaging] =
      AwsError.unwrapOptionField("packaging", packaging)
    def getOverrideArtifactName: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("overrideArtifactName", overrideArtifactName)
    def getEncryptionDisabled: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("encryptionDisabled", encryptionDisabled)
    def getArtifactIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("artifactIdentifier", artifactIdentifier)
    def getBucketOwnerAccess
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BucketOwnerAccess] =
      AwsError.unwrapOptionField("bucketOwnerAccess", bucketOwnerAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectArtifacts
  ) extends zio.aws.codebuild.model.ProjectArtifacts.ReadOnly {
    override val `type`: zio.aws.codebuild.model.ArtifactsType =
      zio.aws.codebuild.model.ArtifactsType.wrap(impl.`type`())
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val path: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => value: String)
    override val namespaceType
        : Optional[zio.aws.codebuild.model.ArtifactNamespace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namespaceType())
        .map(value => zio.aws.codebuild.model.ArtifactNamespace.wrap(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val packaging
        : Optional[zio.aws.codebuild.model.ArtifactPackaging] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packaging())
        .map(value => zio.aws.codebuild.model.ArtifactPackaging.wrap(value))
    override val overrideArtifactName: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrideArtifactName())
        .map(value => value: WrapperBoolean)
    override val encryptionDisabled: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionDisabled())
        .map(value => value: WrapperBoolean)
    override val artifactIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.artifactIdentifier())
      .map(value => value: String)
    override val bucketOwnerAccess
        : Optional[zio.aws.codebuild.model.BucketOwnerAccess] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketOwnerAccess())
        .map(value => zio.aws.codebuild.model.BucketOwnerAccess.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectArtifacts
  ): zio.aws.codebuild.model.ProjectArtifacts.ReadOnly = new Wrapper(impl)
}
