package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCodeCoveragesResponse(
    nextToken: Option[String] = None,
    codeCoverages: Option[Iterable[zio.aws.codebuild.model.CodeCoverage]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesResponse = {
    import DescribeCodeCoveragesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        codeCoverages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.codeCoverages)
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.DescribeCodeCoveragesResponse.ReadOnly =
    zio.aws.codebuild.model.DescribeCodeCoveragesResponse.wrap(buildAwsValue())
}
object DescribeCodeCoveragesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.DescribeCodeCoveragesResponse =
      zio.aws.codebuild.model.DescribeCodeCoveragesResponse(
        nextToken.map(value => value),
        codeCoverages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def codeCoverages
        : Option[List[zio.aws.codebuild.model.CodeCoverage.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCodeCoverages: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.CodeCoverage.ReadOnly
    ]] = AwsError.unwrapOptionField("codeCoverages", codeCoverages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesResponse
  ) extends zio.aws.codebuild.model.DescribeCodeCoveragesResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val codeCoverages
        : Option[List[zio.aws.codebuild.model.CodeCoverage.ReadOnly]] = scala
      .Option(impl.codeCoverages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.CodeCoverage.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesResponse
  ): zio.aws.codebuild.model.DescribeCodeCoveragesResponse.ReadOnly =
    new Wrapper(impl)
}
