package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnvironmentLanguage(
    language: Option[zio.aws.codebuild.model.LanguageType] = None,
    images: Option[Iterable[zio.aws.codebuild.model.EnvironmentImage]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.EnvironmentLanguage = {
    import EnvironmentLanguage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.EnvironmentLanguage
      .builder()
      .optionallyWith(language.map(value => value.unwrap))(_.language)
      .optionallyWith(
        images.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.images)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.EnvironmentLanguage.ReadOnly =
    zio.aws.codebuild.model.EnvironmentLanguage.wrap(buildAwsValue())
}
object EnvironmentLanguage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.EnvironmentLanguage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.EnvironmentLanguage =
      zio.aws.codebuild.model.EnvironmentLanguage(
        language.map(value => value),
        images.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def language: Option[zio.aws.codebuild.model.LanguageType]
    def images: Option[List[zio.aws.codebuild.model.EnvironmentImage.ReadOnly]]
    def getLanguage: ZIO[Any, AwsError, zio.aws.codebuild.model.LanguageType] =
      AwsError.unwrapOptionField("language", language)
    def getImages: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.EnvironmentImage.ReadOnly
    ]] = AwsError.unwrapOptionField("images", images)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.EnvironmentLanguage
  ) extends zio.aws.codebuild.model.EnvironmentLanguage.ReadOnly {
    override val language: Option[zio.aws.codebuild.model.LanguageType] = scala
      .Option(impl.language())
      .map(value => zio.aws.codebuild.model.LanguageType.wrap(value))
    override val images
        : Option[List[zio.aws.codebuild.model.EnvironmentImage.ReadOnly]] =
      scala
        .Option(impl.images())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.EnvironmentImage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.EnvironmentLanguage
  ): zio.aws.codebuild.model.EnvironmentLanguage.ReadOnly = new Wrapper(impl)
}
