package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBuildsRequest(
    sortOrder: Option[zio.aws.codebuild.model.SortOrderType] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListBuildsRequest = {
    import ListBuildsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListBuildsRequest
      .builder()
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ListBuildsRequest.ReadOnly =
    zio.aws.codebuild.model.ListBuildsRequest.wrap(buildAwsValue())
}
object ListBuildsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListBuildsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListBuildsRequest =
      zio.aws.codebuild.model.ListBuildsRequest(
        sortOrder.map(value => value),
        nextToken.map(value => value)
      )
    def sortOrder: Option[zio.aws.codebuild.model.SortOrderType]
    def nextToken: Option[String]
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildsRequest
  ) extends zio.aws.codebuild.model.ListBuildsRequest.ReadOnly {
    override val sortOrder: Option[zio.aws.codebuild.model.SortOrderType] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.codebuild.model.SortOrderType.wrap(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildsRequest
  ): zio.aws.codebuild.model.ListBuildsRequest.ReadOnly = new Wrapper(impl)
}
