package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait CredentialProviderType {
  def unwrap
      : software.amazon.awssdk.services.codebuild.model.CredentialProviderType
}
object CredentialProviderType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.CredentialProviderType
  ): zio.aws.codebuild.model.CredentialProviderType = value match {
    case software.amazon.awssdk.services.codebuild.model.CredentialProviderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.CredentialProviderType.SECRETS_MANAGER =>
      val r = SECRETS_MANAGER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.CredentialProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.CredentialProviderType =
      software.amazon.awssdk.services.codebuild.model.CredentialProviderType.UNKNOWN_TO_SDK_VERSION
  }
  case object SECRETS_MANAGER
      extends zio.aws.codebuild.model.CredentialProviderType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.CredentialProviderType =
      software.amazon.awssdk.services.codebuild.model.CredentialProviderType.SECRETS_MANAGER
  }
}
