package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProjectBadge(
    badgeEnabled: Option[Boolean] = None,
    badgeRequestUrl: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ProjectBadge = {
    import ProjectBadge.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ProjectBadge
      .builder()
      .optionallyWith(badgeEnabled.map(value => value: java.lang.Boolean))(
        _.badgeEnabled
      )
      .optionallyWith(badgeRequestUrl.map(value => value: java.lang.String))(
        _.badgeRequestUrl
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ProjectBadge.ReadOnly =
    zio.aws.codebuild.model.ProjectBadge.wrap(buildAwsValue())
}
object ProjectBadge {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ProjectBadge
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ProjectBadge =
      zio.aws.codebuild.model.ProjectBadge(
        badgeEnabled.map(value => value),
        badgeRequestUrl.map(value => value)
      )
    def badgeEnabled: Option[Boolean]
    def badgeRequestUrl: Option[String]
    def getBadgeEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("badgeEnabled", badgeEnabled)
    def getBadgeRequestUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("badgeRequestUrl", badgeRequestUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectBadge
  ) extends zio.aws.codebuild.model.ProjectBadge.ReadOnly {
    override val badgeEnabled: Option[Boolean] =
      scala.Option(impl.badgeEnabled()).map(value => value: Boolean)
    override val badgeRequestUrl: Option[String] =
      scala.Option(impl.badgeRequestUrl()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectBadge
  ): zio.aws.codebuild.model.ProjectBadge.ReadOnly = new Wrapper(impl)
}
