package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class ListProjectsRequest(
    sortBy: Option[zio.aws.codebuild.model.ProjectSortByType] = None,
    sortOrder: Option[zio.aws.codebuild.model.SortOrderType] = None,
    nextToken: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListProjectsRequest = {
    import ListProjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListProjectsRequest
      .builder()
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ListProjectsRequest.ReadOnly =
    zio.aws.codebuild.model.ListProjectsRequest.wrap(buildAwsValue())
}
object ListProjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListProjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListProjectsRequest =
      zio.aws.codebuild.model.ListProjectsRequest(
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value)
      )
    def sortBy: Option[zio.aws.codebuild.model.ProjectSortByType]
    def sortOrder: Option[zio.aws.codebuild.model.SortOrderType]
    def nextToken: Option[NonEmptyString]
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectSortByType] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListProjectsRequest
  ) extends zio.aws.codebuild.model.ListProjectsRequest.ReadOnly {
    override val sortBy: Option[zio.aws.codebuild.model.ProjectSortByType] =
      scala
        .Option(impl.sortBy())
        .map(value => zio.aws.codebuild.model.ProjectSortByType.wrap(value))
    override val sortOrder: Option[zio.aws.codebuild.model.SortOrderType] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.codebuild.model.SortOrderType.wrap(value))
    override val nextToken: Option[NonEmptyString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListProjectsRequest
  ): zio.aws.codebuild.model.ListProjectsRequest.ReadOnly = new Wrapper(impl)
}
