package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class BuildGroup(
    identifier: Option[String] = None,
    dependsOn: Option[Iterable[NonEmptyString]] = None,
    ignoreFailure: Option[Boolean] = None,
    currentBuildSummary: Option[zio.aws.codebuild.model.BuildSummary] = None,
    priorBuildSummaryList: Option[
      Iterable[zio.aws.codebuild.model.BuildSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BuildGroup = {
    import BuildGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BuildGroup
      .builder()
      .optionallyWith(identifier.map(value => value: java.lang.String))(
        _.identifier
      )
      .optionallyWith(
        dependsOn.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dependsOn)
      .optionallyWith(ignoreFailure.map(value => value: java.lang.Boolean))(
        _.ignoreFailure
      )
      .optionallyWith(currentBuildSummary.map(value => value.buildAwsValue()))(
        _.currentBuildSummary
      )
      .optionallyWith(
        priorBuildSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.priorBuildSummaryList)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BuildGroup.ReadOnly =
    zio.aws.codebuild.model.BuildGroup.wrap(buildAwsValue())
}
object BuildGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BuildGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BuildGroup =
      zio.aws.codebuild.model.BuildGroup(
        identifier.map(value => value),
        dependsOn.map(value => value),
        ignoreFailure.map(value => value),
        currentBuildSummary.map(value => value.asEditable),
        priorBuildSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def identifier: Option[String]
    def dependsOn: Option[List[NonEmptyString]]
    def ignoreFailure: Option[Boolean]
    def currentBuildSummary
        : Option[zio.aws.codebuild.model.BuildSummary.ReadOnly]
    def priorBuildSummaryList
        : Option[List[zio.aws.codebuild.model.BuildSummary.ReadOnly]]
    def getIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getDependsOn: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("dependsOn", dependsOn)
    def getIgnoreFailure: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ignoreFailure", ignoreFailure)
    def getCurrentBuildSummary
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BuildSummary.ReadOnly] =
      AwsError.unwrapOptionField("currentBuildSummary", currentBuildSummary)
    def getPriorBuildSummaryList: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.BuildSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("priorBuildSummaryList", priorBuildSummaryList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BuildGroup
  ) extends zio.aws.codebuild.model.BuildGroup.ReadOnly {
    override val identifier: Option[String] =
      scala.Option(impl.identifier()).map(value => value: String)
    override val dependsOn: Option[List[NonEmptyString]] = scala
      .Option(impl.dependsOn())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val ignoreFailure: Option[Boolean] =
      scala.Option(impl.ignoreFailure()).map(value => value: Boolean)
    override val currentBuildSummary
        : Option[zio.aws.codebuild.model.BuildSummary.ReadOnly] = scala
      .Option(impl.currentBuildSummary())
      .map(value => zio.aws.codebuild.model.BuildSummary.wrap(value))
    override val priorBuildSummaryList
        : Option[List[zio.aws.codebuild.model.BuildSummary.ReadOnly]] = scala
      .Option(impl.priorBuildSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.BuildSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BuildGroup
  ): zio.aws.codebuild.model.BuildGroup.ReadOnly = new Wrapper(impl)
}
