package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProjectFileSystemLocation(
    `type`: Option[zio.aws.codebuild.model.FileSystemType] = None,
    location: Option[String] = None,
    mountPoint: Option[String] = None,
    identifier: Option[String] = None,
    mountOptions: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocation = {
    import ProjectFileSystemLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocation
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(mountPoint.map(value => value: java.lang.String))(
        _.mountPoint
      )
      .optionallyWith(identifier.map(value => value: java.lang.String))(
        _.identifier
      )
      .optionallyWith(mountOptions.map(value => value: java.lang.String))(
        _.mountOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly =
    zio.aws.codebuild.model.ProjectFileSystemLocation.wrap(buildAwsValue())
}
object ProjectFileSystemLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ProjectFileSystemLocation =
      zio.aws.codebuild.model.ProjectFileSystemLocation(
        `type`.map(value => value),
        location.map(value => value),
        mountPoint.map(value => value),
        identifier.map(value => value),
        mountOptions.map(value => value)
      )
    def `type`: Option[zio.aws.codebuild.model.FileSystemType]
    def location: Option[String]
    def mountPoint: Option[String]
    def identifier: Option[String]
    def mountOptions: Option[String]
    def getType: ZIO[Any, AwsError, zio.aws.codebuild.model.FileSystemType] =
      AwsError.unwrapOptionField("type", `type`)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getMountPoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("mountPoint", mountPoint)
    def getIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getMountOptions: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocation
  ) extends zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly {
    override val `type`: Option[zio.aws.codebuild.model.FileSystemType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.codebuild.model.FileSystemType.wrap(value))
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
    override val mountPoint: Option[String] =
      scala.Option(impl.mountPoint()).map(value => value: String)
    override val identifier: Option[String] =
      scala.Option(impl.identifier()).map(value => value: String)
    override val mountOptions: Option[String] =
      scala.Option(impl.mountOptions()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocation
  ): zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly = new Wrapper(
    impl
  )
}
