package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RetryBuildResponse(
    build: Option[zio.aws.codebuild.model.Build] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.RetryBuildResponse = {
    import RetryBuildResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.RetryBuildResponse
      .builder()
      .optionallyWith(build.map(value => value.buildAwsValue()))(_.build)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.RetryBuildResponse.ReadOnly =
    zio.aws.codebuild.model.RetryBuildResponse.wrap(buildAwsValue())
}
object RetryBuildResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.RetryBuildResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.RetryBuildResponse =
      zio.aws.codebuild.model
        .RetryBuildResponse(build.map(value => value.asEditable))
    def build: Option[zio.aws.codebuild.model.Build.ReadOnly]
    def getBuild: ZIO[Any, AwsError, zio.aws.codebuild.model.Build.ReadOnly] =
      AwsError.unwrapOptionField("build", build)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.RetryBuildResponse
  ) extends zio.aws.codebuild.model.RetryBuildResponse.ReadOnly {
    override val build: Option[zio.aws.codebuild.model.Build.ReadOnly] = scala
      .Option(impl.build())
      .map(value => zio.aws.codebuild.model.Build.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.RetryBuildResponse
  ): zio.aws.codebuild.model.RetryBuildResponse.ReadOnly = new Wrapper(impl)
}
