package zio.aws.codeartifact.model
import scala.jdk.CollectionConverters.*
sealed trait PackageFormat {
  def unwrap: software.amazon.awssdk.services.codeartifact.model.PackageFormat
}
object PackageFormat {
  def wrap(
      value: software.amazon.awssdk.services.codeartifact.model.PackageFormat
  ): zio.aws.codeartifact.model.PackageFormat = value match {
    case software.amazon.awssdk.services.codeartifact.model.PackageFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageFormat.NPM =>
      val r = npm
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageFormat.PYPI =>
      val r = pypi
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageFormat.MAVEN =>
      val r = maven
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageFormat.NUGET =>
      val r = nuget
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageFormat.GENERIC =>
      val r = generic
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageFormat.SWIFT =>
      val r = swift
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeartifact.model.PackageFormat {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageFormat =
      software.amazon.awssdk.services.codeartifact.model.PackageFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object npm extends zio.aws.codeartifact.model.PackageFormat {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageFormat =
      software.amazon.awssdk.services.codeartifact.model.PackageFormat.NPM
  }
  case object pypi extends zio.aws.codeartifact.model.PackageFormat {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageFormat =
      software.amazon.awssdk.services.codeartifact.model.PackageFormat.PYPI
  }
  case object maven extends zio.aws.codeartifact.model.PackageFormat {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageFormat =
      software.amazon.awssdk.services.codeartifact.model.PackageFormat.MAVEN
  }
  case object nuget extends zio.aws.codeartifact.model.PackageFormat {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageFormat =
      software.amazon.awssdk.services.codeartifact.model.PackageFormat.NUGET
  }
  case object generic extends zio.aws.codeartifact.model.PackageFormat {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageFormat =
      software.amazon.awssdk.services.codeartifact.model.PackageFormat.GENERIC
  }
  case object swift extends zio.aws.codeartifact.model.PackageFormat {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageFormat =
      software.amazon.awssdk.services.codeartifact.model.PackageFormat.SWIFT
  }
}
