package zio.aws.codeartifact.model
import zio.aws.codeartifact.model.primitives.{
  AccountId,
  Timestamp,
  DomainName,
  RepositoryName,
  Arn,
  Description
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class RepositorySummary(
    name: Optional[RepositoryName] = Optional.Absent,
    administratorAccount: Optional[AccountId] = Optional.Absent,
    domainName: Optional[DomainName] = Optional.Absent,
    domainOwner: Optional[AccountId] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.RepositorySummary = {
    import RepositorySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.RepositorySummary
      .builder()
      .optionallyWith(
        name.map(value => RepositoryName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        administratorAccount.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.administratorAccount)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.RepositorySummary.ReadOnly =
    zio.aws.codeartifact.model.RepositorySummary.wrap(buildAwsValue())
}
object RepositorySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.RepositorySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.RepositorySummary =
      zio.aws.codeartifact.model.RepositorySummary(
        name.map(value => value),
        administratorAccount.map(value => value),
        domainName.map(value => value),
        domainOwner.map(value => value),
        arn.map(value => value),
        description.map(value => value),
        createdTime.map(value => value)
      )
    def name: Optional[RepositoryName]
    def administratorAccount: Optional[AccountId]
    def domainName: Optional[DomainName]
    def domainOwner: Optional[AccountId]
    def arn: Optional[Arn]
    def description: Optional[Description]
    def createdTime: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("name", name)
    def getAdministratorAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("administratorAccount", administratorAccount)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.RepositorySummary
  ) extends zio.aws.codeartifact.model.RepositorySummary.ReadOnly {
    override val name: Optional[RepositoryName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codeartifact.model.primitives.RepositoryName(value))
    override val administratorAccount: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.administratorAccount())
        .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.codeartifact.model.primitives.DomainName(value))
    override val domainOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.codeartifact.model.primitives.Arn(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.codeartifact.model.primitives.Description(value))
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.codeartifact.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.RepositorySummary
  ): zio.aws.codeartifact.model.RepositorySummary.ReadOnly = new Wrapper(impl)
}
